/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.Conversation;
import org.eclipse.vtp.framework.api.ExecutionFailure;
import org.eclipse.vtp.framework.api.ExecutionResult;
import org.eclipse.vtp.framework.api.Field;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.api.InvalidResponseStrategy;
import org.eclipse.vtp.framework.api.RetryLimitStrategy;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.w3c.dom.Element;

public class FieldModule
implements Module {
    private String id;
    private String varName;
    boolean bargeIn = true;
    boolean hasTermDigit = true;
    String termDigit = "#";
    int terminationTimeout = 3;
    int interdigitTimeout = 3;
    boolean retriesSeparate = false;
    int noInputLimit = 2;
    int noMatchLimit = 2;
    int badInputLimit = 2;
    Map hooks = new HashMap();
    Map endPoints = new HashMap();
    private Properties configuration = new Properties();

    public FieldModule(String id) {
        this.id = id;
    }

    public void addSetting(String name, Object value) {
    }

    public List getPreconditions() {
        return new ArrayList();
    }

    public void readSettings(Element element) {
        this.varName = element.getAttribute("var-name");
        if (!element.getAttribute("barge-in").equals("")) {
            this.bargeIn = Boolean.valueOf(element.getAttribute("barge-in"));
        }
        if (!element.getAttribute("has-term-digit").equals("")) {
            this.hasTermDigit = Boolean.valueOf(element.getAttribute("has-term-digit"));
        }
        if (!element.getAttribute("term-digit").equals("")) {
            this.termDigit = element.getAttribute("term-digit");
        }
        if (!element.getAttribute("term-timeout").equals("")) {
            try {
                this.terminationTimeout = Integer.parseInt(element.getAttribute("term-timeout"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("inter-digit-timeout").equals("")) {
            try {
                this.interdigitTimeout = Integer.parseInt(element.getAttribute("inter-digit-timeout"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("retry-strategy").equals("")) {
            this.retriesSeparate = element.getAttribute("retry-strategy").equals("separate");
        }
        if (!element.getAttribute("no-input-limit").equals("")) {
            try {
                this.noInputLimit = Integer.parseInt(element.getAttribute("no-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("no-match-limit").equals("")) {
            try {
                this.noMatchLimit = Integer.parseInt(element.getAttribute("no-match-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("bad-input-limit").equals("")) {
            try {
                this.badInputLimit = Integer.parseInt(element.getAttribute("bad-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Interaction getInstance() {
        return new FieldInteraction();
    }

    public ModuleDestination getHookDestination(String hookName) {
        return (ModuleDestination)this.hooks.get(hookName);
    }

    public void registerHookDestination(String hookName, ModuleDestination destination) {
        this.hooks.put(hookName, destination);
    }

    public void registerEndPointDestination(String endPointName, Destination destination) {
        this.endPoints.put(endPointName, destination);
    }

    public Destination getEndPointDestination(String endPointName) {
        return (Destination)this.endPoints.get(endPointName);
    }

    public void setTimeoutDestination(Destination timeoutDestination) {
    }

    public Destination getTimeoutDestination() {
        return null;
    }

    public Map getSettings() {
        return new HashMap();
    }

    public String getName() {
        return "Field";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return "builtin.field.1_0_0_0";
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String name, String value) {
        this.configuration.setProperty(name, value);
    }

    public class FieldInteraction
    implements Interaction {
        public ExecutionResult execute(Conversation conversation) {
            BObject var;
            ExecutionResult next = ExecutionResult.success((String)"Next");
            ExecutionFailure noMatchFailure = ExecutionResult.failure((String)"error.input.nomatch");
            ExecutionFailure noInputFailure = ExecutionResult.failure((String)"error.input.noinput");
            Field field = conversation.createField("Field");
            field.setName("BuiltInField");
            if (FieldModule.this.retriesSeparate) {
                field.setInvalidResponseStrategy(new InvalidResponseStrategy(this){
                    int niFailures;
                    int nmFailures;
                    final /* synthetic */ FieldInteraction this$1;
                    {
                        this.this$1 = fieldInteraction;
                        this.niFailures = 0;
                        this.nmFailures = 0;
                    }

                    public boolean noMatch() {
                        ++this.nmFailures;
                        return this.nmFailures < FieldInteraction.access$0((FieldInteraction)this.this$1).noInputLimit;
                    }

                    public boolean noInput() {
                        ++this.niFailures;
                        return this.niFailures < FieldInteraction.access$0((FieldInteraction)this.this$1).noMatchLimit;
                    }
                });
            } else {
                field.setInvalidResponseStrategy((InvalidResponseStrategy)new RetryLimitStrategy(FieldModule.this.badInputLimit));
            }
            if (field.processRequest()) {
                var = conversation.getVariable(FieldModule.this.varName);
                if (var == null) {
                    var = conversation.createObject(FieldModule.this.varName, "String", false);
                    conversation.registerVariable(FieldModule.this.varName, var);
                }
            } else {
                if (field.failedWithNoMatch()) {
                    return noMatchFailure;
                }
                return noInputFailure;
            }
            var.setValue((Object)field.getValue());
            return next;
        }

        static /* synthetic */ FieldModule access$0(FieldInteraction fieldInteraction) {
            return fieldInteraction.FieldModule.this;
        }
    }
}

