/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.util.Map;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.api.Recording;
import org.eclipse.vtp.framework.kernel.spi.AbstractKernelRequest;
import org.eclipse.vtp.framework.kernel.spi.MediaRenderer;
import org.eclipse.vtp.framework.media.util.DialogAggregate;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.Assignment;
import org.eclipse.vtp.framework.widgets.vxml.Block;
import org.eclipse.vtp.framework.widgets.vxml.Catch;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.Filled;
import org.eclipse.vtp.framework.widgets.vxml.Form;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.NoInput;
import org.eclipse.vtp.framework.widgets.vxml.Submit;
import org.eclipse.vtp.framework.widgets.vxml.Variable;

public class DefaultRecording
extends AbstractKernelRequest
implements Recording {
    private int finalSilence = -1;
    private Boolean beepOn = null;
    private Boolean dtmfTermOn = null;
    private int maxTime = -1;
    private int initialTimeout = -1;
    private String recordingURL = null;

    public DefaultRecording() {
        this.setPrompt(Prompt.named((String)"recording"));
        this.setNoInputPrompt(Prompt.named((String)"no-input"));
        this.setNoMatchPrompt(Prompt.named((String)"no-match"));
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    public boolean isValid(Map data) {
        return true;
    }

    protected void setResponse(Map data) {
        String[] results = (String[])data.get(this.getName());
        if (results != null && results.length > 0) {
            this.recordingURL = results[0];
            System.err.println("\r\n\r\n\r\n" + this.recordingURL + "\r\n\r\n\r\n");
        }
    }

    public int getFinalSilence() {
        return this.finalSilence;
    }

    public void setFinalSilence(int finalSilence) {
        this.finalSilence = finalSilence;
    }

    public Boolean getBeepOn() {
        return this.beepOn;
    }

    public void setBeepOn(Boolean beepOn) {
        this.beepOn = beepOn;
    }

    public Boolean getDTMFTermOn() {
        return this.dtmfTermOn;
    }

    public void setDTMFTermOn(Boolean termOn) {
        this.dtmfTermOn = termOn;
    }

    public String getRecording() {
        return this.recordingURL;
    }

    public void setInterdigitTimeout(int timeout) {
    }

    public void setTerminationTimeout(int timeout) {
    }

    public void setInitialTimeout(int timeout) {
        this.initialTimeout = timeout;
    }

    public void canBargeIn(boolean bargeIn) {
    }

    public Dialog produceDialog(String callId) {
        MediaRenderer renderer = this.getMediaRenderer();
        Prompt prompt = null;
        if (this.failedWithNoInput()) {
            prompt = this.getNoInputPrompt() == null ? Prompt.named((String)"no-input") : this.getNoInputPrompt();
            prompt = prompt.followedBy(this.getPrompt() == null ? Prompt.named((String)"recording") : this.getPrompt());
        } else if (this.failedWithNoMatch()) {
            prompt = this.getNoMatchPrompt() == null ? Prompt.named((String)"no-match") : this.getNoMatchPrompt();
            prompt = prompt.followedBy(this.getPrompt() == null ? Prompt.named((String)"recording") : this.getPrompt());
        } else {
            prompt = this.getPrompt() == null ? Prompt.named((String)"recording") : this.getPrompt();
        }
        DialogAggregate dialog = renderer.getDialog(this.getDialogName());
        org.eclipse.vtp.framework.widgets.vxml.Recording recording = new org.eclipse.vtp.framework.widgets.vxml.Recording(this.getName());
        if (dialog != null) {
            if (this.initialTimeout >= 0) {
                recording.setTimeout(String.valueOf(this.initialTimeout) + "s");
            } else if (dialog.getInitialInputTimeout() >= 0L) {
                recording.setTimeout(String.valueOf(String.valueOf(dialog.getInitialInputTimeout())) + "s");
            }
            if (this.finalSilence >= 0) {
                recording.setFinalSilence(String.valueOf(this.finalSilence) + "s");
            } else if (dialog.getFinalSilence() >= 0L) {
                recording.setFinalSilence(String.valueOf(dialog.getFinalSilence()) + "s");
            }
            if (this.beepOn != null) {
                recording.setBeep(this.beepOn.booleanValue());
            } else if (dialog.isBeepOn() != null) {
                recording.setBeep(dialog.isBeepOn().booleanValue());
            }
            if (this.dtmfTermOn != null) {
                recording.setDtmfTermOn(this.dtmfTermOn.booleanValue());
            } else if (dialog.isDtmfTermOn() != null) {
                recording.setDtmfTermOn(dialog.isDtmfTermOn().booleanValue());
            }
            if (this.maxTime >= 0) {
                recording.setMaxtime(String.valueOf(this.maxTime) + "s");
            } else if (dialog.getMaxTime() >= 0L) {
                recording.setMaxtime(String.valueOf(dialog.getMaxTime()) + "s");
            }
        } else {
            if (this.initialTimeout >= 0) {
                recording.setTimeout(String.valueOf(this.initialTimeout) + "s");
            }
            if (this.finalSilence >= 0) {
                recording.setFinalSilence(String.valueOf(this.finalSilence) + "s");
            }
            if (this.beepOn != null) {
                recording.setBeep(this.beepOn.booleanValue());
            }
            if (this.dtmfTermOn != null) {
                recording.setDtmfTermOn(this.dtmfTermOn.booleanValue());
            }
            if (this.maxTime >= 0) {
                recording.setMaxtime(String.valueOf(this.maxTime) + "s");
            }
        }
        recording.addProperty("com.telera.speechenabled", "false");
        recording.addProperty("inputmodes", "dtmf");
        recording.setFileType("audio/x-wav");
        recording.setPrompt(renderer.renderPrompt(this.getPrompt() == null ? Prompt.named((String)"field") : this.getPrompt(), dialog == null ? false : (dialog.getBargeIn() == null ? false : dialog.getBargeIn())));
        Filled filled = new Filled();
        Submit submit = new Submit("/openVXML", new String[]{this.getName(), "KERNEL_CALL_ID", "KERNEL_EVENT"});
        submit.setMethod("post");
        submit.setEncodingType("multipart/form-data");
        filled.addAction((Action)submit);
        recording.addFilledHandler(filled);
        NoInput noInput = new NoInput();
        noInput.addAction((Action)new Assignment("KERNEL_EVENT", "\"NOINPUT\""));
        noInput.addAction((Action)new Submit("/openVXML", new String[]{this.getName(), "KERNEL_CALL_ID", "KERNEL_EVENT"}));
        recording.addEventHandler((EventHandler)noInput);
        Catch hangupHandler = new Catch("error.disconnect.hangup");
        Submit submit2 = new Submit("/openVXML", new String[]{this.getName(), "KERNEL_CALL_ID", "KERNEL_EVENT"});
        submit2.setMethod("post");
        submit2.setEncodingType("multipart/form-data");
        hangupHandler.addAction((Action)submit2);
        recording.addEventHandler((EventHandler)hangupHandler);
        Form form = new Form("Default_Field_Form");
        form.addVariable(new Variable("KERNEL_CALL_ID", "'" + callId + "'"));
        form.addVariable(new Variable("KERNEL_EVENT", "'FILLED'"));
        if (this.failedWithNoInput()) {
            Block block = new Block("Default_Field_No_Input_Block");
            block.addAction((Action)renderer.renderPrompt(this.getNoInputPrompt() == null ? Prompt.named((String)"no-input") : this.getNoInputPrompt()));
            form.addFormElement((FormElement)block);
        } else if (this.failedWithNoMatch()) {
            Block block = new Block("Default_Field_No_Match_Block");
            block.addAction((Action)renderer.renderPrompt(this.getNoMatchPrompt() == null ? Prompt.named((String)"no-match") : this.getNoMatchPrompt()));
            form.addFormElement((FormElement)block);
        }
        form.addFormElement((FormElement)recording);
        return form;
    }
}

