/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.vtp.framework.api.AttachedDataPost;
import org.eclipse.vtp.framework.api.AttachedDataRequest;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.BString;
import org.eclipse.vtp.framework.api.Conversation;
import org.eclipse.vtp.framework.api.ExecutionResult;
import org.eclipse.vtp.framework.api.Field;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.api.Menu;
import org.eclipse.vtp.framework.api.Message;
import org.eclipse.vtp.framework.api.SubdialogRequest;
import org.eclipse.vtp.framework.kernel.api.ApplicationTransferDestination;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.DialogProducer;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.eclipse.vtp.framework.kernel.spi.AbstractKernelRequest;
import org.eclipse.vtp.framework.kernel.spi.KernelPost;
import org.eclipse.vtp.framework.kernel.spi.KernelRequest;
import org.eclipse.vtp.framework.kernel.spi.PlatformException;
import org.eclipse.vtp.framework.kernel.spi.VoicePlatform;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.widgets.WidgetDocument;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.Assignment;
import org.eclipse.vtp.framework.widgets.vxml.Block;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.Form;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.Goto;
import org.eclipse.vtp.framework.widgets.vxml.Submit;
import org.eclipse.vtp.framework.widgets.vxml.VXMLDocument;
import org.eclipse.vtp.framework.widgets.vxml.Variable;

public class GenericVoicePlatform
implements VoicePlatform {
    private String contextPath = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath == null ? "" : contextPath;
    }

    protected String getContextPath() {
        return this.contextPath;
    }

    public Destination getInitializer() {
        return new ModuleDestination(new PlatformVariableModule());
    }

    public KernelPost createPost(String namespace) {
        try {
            KernelPost post = (KernelPost)Class.forName(namespace).newInstance();
            return post;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PlatformException("Post type '" + namespace + "' not found");
        }
        catch (InstantiationException instantiationException) {
            throw new PlatformException("Could not create message of type '" + namespace + "'");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PlatformException("Cannot access message of type '" + namespace + "'");
        }
    }

    public Message createMessage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.kernel.spi.DefaultMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Message)this.createPost(clazz.getName());
    }

    public KernelRequest createRequest(String namespace) {
        if (namespace.equals("VariableRequest")) {
            return new VariableRequest();
        }
        try {
            KernelRequest request = (KernelRequest)Class.forName(namespace).newInstance();
            return request;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PlatformException("Post type '" + namespace + "' not found");
        }
        catch (InstantiationException instantiationException) {
            throw new PlatformException("Could not create request of type '" + namespace + "'");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PlatformException("Cannot access request of type '" + namespace + "'");
        }
    }

    public Field createField() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.vtp.framework.kernel.spi.DefaultField");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Field)this.createRequest(clazz.getName());
    }

    public Menu createMenu() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.vtp.framework.kernel.spi.DefaultMenu");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Menu)this.createRequest(clazz.getName());
    }

    public AttachedDataRequest createAttachedDataRequest() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.vtp.framework.kernel.spi.DefaultAttachedDataRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AttachedDataRequest)this.createRequest(clazz.getName());
    }

    public AttachedDataPost createAttachedDataPost() {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.vtp.framework.kernel.spi.DefaultAttachedDataPost");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AttachedDataPost)this.createPost(clazz.getName());
    }

    public WidgetDocument buildDocument(Object component) {
        if (component instanceof Destination) {
            return this.buildDestinationDocument((Destination)component);
        }
        return null;
    }

    private WidgetDocument buildDestinationDocument(Destination destination) {
        if (destination instanceof ApplicationTransferDestination) {
            Form f = new Form("Transfer_Form");
            Block block = new Block("Transfer_Block");
            Goto appGoto = new Goto(String.valueOf(this.contextPath) + "/openVXML" + "?DID=" + ((ApplicationTransferDestination)destination).getDN() + "&ANI=");
            block.addAction((Action)appGoto);
            f.addFormElement((FormElement)block);
            VXMLDocument ret = new VXMLDocument();
            ret.addDialog((Dialog)f);
            return ret;
        }
        return null;
    }

    public SubdialogRequest createSubdialog() {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.vtp.framework.kernel.spi.DefaultSubdialogRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (SubdialogRequest)this.createRequest(clazz.getName());
    }

    public class PlatformVariableModule
    implements Module,
    Interaction {
        public String id = Guid.createGUID();

        public void addSetting(String name, Object value) {
        }

        public Properties getConfiguration() {
            return null;
        }

        public Destination getEndPointDestination(String endPointName) {
            return null;
        }

        public ModuleDestination getHookDestination(String hookName) {
            return null;
        }

        public String getId() {
            return this.id;
        }

        public Interaction getInstance() {
            return this;
        }

        public String getName() {
            return this.id;
        }

        public List getPreconditions() {
            return null;
        }

        public Map getSettings() {
            return null;
        }

        public Destination getTimeoutDestination() {
            return null;
        }

        public String getType() {
            return "builtin.generic.platform.variables";
        }

        public void registerEndPointDestination(String endPointName, Destination destination) {
        }

        public void registerHookDestination(String hookName, ModuleDestination destination) {
        }

        public void setConfiguration(String name, String value) {
        }

        public void setTimeoutDestination(Destination timeoutDestination) {
        }

        public ExecutionResult execute(Conversation conversation) {
            BObject platformObject = conversation.createObject("Platform", "Platform", false);
            BString dnis = (BString)platformObject.getField("DNIS");
            dnis.setValue((Object)"");
            BString ani = (BString)platformObject.getField("ANI");
            ani.setValue((Object)"");
            BString brand = (BString)platformObject.getField("Brand");
            brand.setValue((Object)conversation.getBrand());
            conversation.registerVariable(platformObject);
            VariableRequest vr = (VariableRequest)conversation.createRequest("VariableRequest");
            vr.setName("GetPlatformVariables");
            if (vr.processRequest()) {
                dnis.setValue((Object)vr.getDNIS());
                ani.setValue((Object)vr.getANI());
            }
            return ExecutionResult.success((String)"done");
        }
    }

    public class VariableRequest
    extends AbstractKernelRequest
    implements DialogProducer {
        String dnis = null;
        String ani = null;

        public boolean isValid(Map data) {
            return true;
        }

        protected void setResponse(Map data) {
            this.dnis = data.get("PlatformDNIS") == null ? null : ((String[])data.get("PlatformDNIS"))[0];
            this.ani = data.get("PlatformANI") == null ? null : ((String[])data.get("PlatformANI"))[0];
        }

        public String getANI() {
            return this.ani;
        }

        public String getDNIS() {
            return this.dnis;
        }

        public Dialog produceDialog(String callid) {
            Form f = new Form("VariableForm");
            f.addVariable(new Variable("KERNEL_CALL_ID", "'" + callid + "'"));
            f.addVariable(new Variable("KERNEL_EVENT", "'FILLED'"));
            f.addVariable(new Variable("PlatformDNIS"));
            f.addVariable(new Variable("PlatformANI"));
            Block b = new Block("VariableBlock");
            f.addFormElement((FormElement)b);
            Assignment a_dnis = new Assignment("PlatformDNIS", "session.connection.local.uri");
            b.addAction((Action)a_dnis);
            Assignment a_ani = new Assignment("PlatformANI", "session.connection.remote.uri");
            b.addAction((Action)a_ani);
            Submit s = new Submit(String.valueOf(this.getKernel().getContextPath()) + "/openVXML", new String[]{"KERNEL_CALL_ID", "KERNEL_EVENT", "PlatformDNIS", "PlatformANI"});
            b.addAction((Action)s);
            return f;
        }
    }
}

