/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.core.project.IBrandSet;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningModelAction;
import org.eclipse.vtp.desktop.ui.shared.actions.util.IProvisioningModelSelection;

public class DeleteBrandAction
implements IProvisioningModelAction {
    public String getName() {
        return "DeleteBrandAction";
    }

    public String getToolTip() {
        return "Deletes this brand";
    }

    public void performAction(IProvisioningModelSelection selection) {
        IBrand brand = (IBrand)selection.getSelectedObject();
        IBrandSet brandSet = brand.getBrandSet();
        MessageDialog md = new MessageDialog(Display.getCurrent().getActiveShell(), "Confimation Dialog", null, "Are you sure you want to delete the " + brand.getName() + " brand permanently?", 4, new String[]{"No", "Yes"}, 1);
        int op = md.open();
        if (op == 1) {
            try {
                brandSet.removeBrand(brand.getName());
                brandSet.refresh();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

