/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.ui.app.dialogs.GrammarChooserDialog;
import org.eclipse.vtp.desktop.ui.app.dialogs.MediaFileChooserDialog;
import org.eclipse.vtp.framework.media.grammars.FileGrammar;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;

public class GrammarDialog
extends Dialog {
    private String name;
    private boolean nameEditable;
    private Map grammarListsByLocale;
    private boolean simpleGrammarsOnly;
    private IMediaFilesFolder[] folders;
    private Map grammarOptions;
    private Text nameText = null;
    private TreeViewer langTree = null;
    private IStructuredSelection langSelection = StructuredSelection.EMPTY;
    private Combo type = null;
    private Composite contents = null;
    private StackLayout stack = null;
    private Label empty = null;
    private Composite fileContent = null;
    private Text fileText = null;
    private int fileIndex = 0;
    private Composite referenceContent = null;
    private Text referenceText = null;
    private int referenceIndex = 0;
    private List current = null;

    public GrammarDialog(Shell parentShell, String name, boolean nameEditable, Map grammarListsByLocale, boolean simpleGrammarsOnly, IMediaFilesFolder[] folders, Map grammarOptions) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.name = name;
        this.nameEditable = nameEditable;
        this.grammarListsByLocale = grammarListsByLocale;
        this.simpleGrammarsOnly = simpleGrammarsOnly;
        this.folders = folders;
        this.grammarOptions = grammarOptions;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText("Configure Grammars");
        this.getShell().pack();
        this.getShell().setSize(500, 350);
        this.getButton(0).setEnabled(this.name.length() > 0);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite root = new Composite(composite, 0);
        root.setLayoutData((Object)new GridData(1808));
        root.setLayout((Layout)new GridLayout(2, false));
        new Label(root, 0).setText("Name:");
        this.nameText = new Text(root, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.name);
        this.nameText.setEditable(this.nameEditable);
        if (this.nameEditable) {
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GrammarDialog.this.getButton(0).setEnabled(GrammarDialog.this.nameText.getText().length() > 0);
                }
            });
        }
        SashForm sash = new SashForm(root, 256);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        sash.setLayoutData((Object)gd);
        Group langGroup = new Group((Composite)sash, 0);
        langGroup.setText("Languages");
        langGroup.setLayoutData((Object)new GridData(1808));
        langGroup.setLayout((Layout)new GridLayout(1, true));
        this.langTree = new TreeViewer((Composite)langGroup, 772);
        this.langTree.getControl().setLayoutData((Object)new GridData(1808));
        LangContentProvider lcp = new LangContentProvider();
        this.langTree.setContentProvider((IContentProvider)lcp);
        this.langTree.setLabelProvider((IBaseLabelProvider)lcp);
        this.langTree.setSorter(new ViewerSorter());
        this.langTree.setInput(this.grammarListsByLocale.keySet());
        Group entriesGroup = new Group((Composite)sash, 0);
        entriesGroup.setText("Entries");
        entriesGroup.setLayoutData((Object)new GridData(1808));
        entriesGroup.setLayout((Layout)new GridLayout(1, true));
        this.type = new Combo((Composite)entriesGroup, 12);
        this.type.setLayoutData((Object)new GridData(768));
        int i = -1;
        this.type.add("No Grammar Applied");
        ++i;
        this.type.add("File");
        ++i;
        this.fileIndex = i++;
        if (!this.simpleGrammarsOnly) {
            this.type.add("Reference");
            this.referenceIndex = i;
        }
        this.type.select(0);
        this.contents = new Composite((Composite)entriesGroup, 0);
        this.contents.setLayoutData((Object)new GridData(1808));
        this.stack = new StackLayout();
        this.contents.setLayout((Layout)this.stack);
        this.empty = new Label(this.contents, 0);
        this.empty.setText("Select a language on the left");
        this.fileContent = new Composite(this.contents, 0);
        this.fileContent.setLayout((Layout)new GridLayout(2, false));
        this.fileText = new Text(this.fileContent, 2060);
        this.fileText.setLayoutData((Object)new GridData(768));
        Button fileBrowse = new Button(this.fileContent, 8);
        fileBrowse.setText("Browse...");
        this.referenceContent = new Composite(this.contents, 0);
        this.referenceContent.setLayout((Layout)new GridLayout(2, false));
        this.referenceText = new Text(this.referenceContent, 2060);
        this.referenceText.setLayoutData((Object)new GridData(768));
        Button referenceBrowse = new Button(this.referenceContent, 8);
        referenceBrowse.setText("Browse...");
        this.langTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GrammarDialog.this.langSelection = (IStructuredSelection)GrammarDialog.this.langTree.getSelection();
                GrammarDialog.this.langSelectionChanged();
            }
        });
        if (!this.grammarListsByLocale.isEmpty()) {
            this.langTree.setSelection((ISelection)new StructuredSelection(this.grammarListsByLocale.keySet().iterator().next()));
        } else {
            this.langTree.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        sash.setWeights(new int[]{30, 70});
        Locale selected = new Locale(Locale.getDefault().getLanguage());
        if (!this.grammarListsByLocale.containsKey(selected)) {
            selected = (Locale)this.grammarListsByLocale.keySet().iterator().next();
        }
        System.err.println(selected);
        this.langTree.setSelection((ISelection)new StructuredSelection((Object)selected));
        fileBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MediaFileChooserDialog dialog = new MediaFileChooserDialog(GrammarDialog.this.getShell(), GrammarDialog.this.folders, GrammarDialog.this.fileText.getText());
                if (dialog.open() != 0) {
                    GrammarDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                if (dialog.getValue() == null || dialog.getValue().equals("")) {
                    GrammarDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                GrammarDialog.this.fileText.setText(dialog.getValue());
                GrammarDialog.this.getButton(0).setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        referenceBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String ref = GrammarDialog.this.referenceText.getText();
                int at = ref.indexOf(64);
                GrammarChooserDialog dialog = new GrammarChooserDialog(GrammarDialog.this.getShell(), ref.substring(at + 1), at >= 0 ? ref.substring(0, at) : "", GrammarDialog.this.grammarOptions);
                if (dialog.open() != 0) {
                    GrammarDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                ref = dialog.getName();
                if (ref == null || ref.equals("")) {
                    GrammarDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                GrammarDialog.this.referenceText.setText(ref);
                GrammarDialog.this.getButton(0).setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (GrammarDialog.this.type.getSelectionIndex() == GrammarDialog.this.fileIndex) {
                    ((GrammarDialog)GrammarDialog.this).stack.topControl = GrammarDialog.this.fileContent;
                    GrammarDialog.this.getButton(0).setEnabled(GrammarDialog.this.fileText.getText() != null && !GrammarDialog.this.fileText.getText().equals(""));
                } else if (GrammarDialog.this.type.getSelectionIndex() == GrammarDialog.this.referenceIndex) {
                    ((GrammarDialog)GrammarDialog.this).stack.topControl = GrammarDialog.this.referenceContent;
                    GrammarDialog.this.getButton(0).setEnabled(GrammarDialog.this.referenceText.getText() != null && !GrammarDialog.this.referenceText.getText().equals(""));
                } else {
                    ((GrammarDialog)GrammarDialog.this).stack.topControl = GrammarDialog.this.empty;
                    GrammarDialog.this.getButton(0).setEnabled(true);
                }
                GrammarDialog.this.contents.layout();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    private void langSelectionChanged() {
        if (this.current != null) {
            this.current.clear();
            if (this.fileIndex == this.type.getSelectionIndex() && this.fileText.getText() != null && !this.fileText.getText().equals("")) {
                this.current.add(new FileGrammar(this.fileText.getText()));
            } else if (this.referenceIndex == this.type.getSelectionIndex() && this.referenceText.getText() != null && !this.referenceText.getText().equals("")) {
                this.current.add(new ReferenceGrammar(this.referenceText.getText()));
            }
            this.current = null;
        }
        if (this.langSelection.size() > 0) {
            this.type.setEnabled(true);
            this.current = (List)this.grammarListsByLocale.get(this.langSelection.getFirstElement());
            if (this.current != null && this.current.size() > 0) {
                Object grammar = this.current.iterator().next();
                this.type.setEnabled(true);
                if (grammar instanceof ReferenceGrammar) {
                    this.type.select(this.referenceIndex);
                    this.referenceText.setText(((ReferenceGrammar)grammar).getName());
                    this.stack.topControl = this.referenceContent;
                } else {
                    this.type.select(this.fileIndex);
                    if (grammar instanceof FileGrammar) {
                        this.fileText.setText(((FileGrammar)grammar).getPath());
                    }
                    this.stack.topControl = this.fileContent;
                }
            } else {
                this.type.select(0);
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(true);
                }
                this.fileText.setText("");
                this.referenceText.setText("");
                this.stack.topControl = this.empty;
            }
            this.contents.layout();
            return;
        }
        this.current = null;
        this.type.setEnabled(false);
        this.stack.topControl = this.empty;
        this.contents.layout();
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        if (this.current != null) {
            this.current.clear();
            System.err.println(this.type.getSelectionIndex());
            System.err.println(this.fileIndex);
            System.err.println(this.referenceIndex);
            if (this.fileIndex == this.type.getSelectionIndex()) {
                this.current.add(new FileGrammar(this.fileText.getText()));
            } else if (this.referenceIndex == this.type.getSelectionIndex()) {
                this.current.add(new ReferenceGrammar(this.referenceText.getText()));
            }
            this.current = null;
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public Map getGrammarListsByLocale() {
        return this.grammarListsByLocale;
    }

    private final class LangContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private Map localeTree = new HashMap();

        private LangContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Locale parent;
            Locale locale;
            this.localeTree.clear();
            if (!(newInput instanceof Set)) {
                return;
            }
            HashSet locales = new HashSet((Set)newInput);
            ArrayList<Locale> languages = new ArrayList<Locale>(locales.size());
            Iterator i = locales.iterator();
            while (i.hasNext()) {
                locale = (Locale)i.next();
                if (!"".equals(locale.getCountry())) continue;
                languages.add(locale);
                i.remove();
            }
            this.localeTree.put(null, languages);
            i = locales.iterator();
            while (i.hasNext()) {
                locale = (Locale)i.next();
                if (!"".equals(locale.getVariant())) continue;
                parent = new Locale(locale.getLanguage());
                ArrayList<Locale> countries = (ArrayList<Locale>)this.localeTree.get(parent);
                if (countries == null) {
                    countries = new ArrayList<Locale>();
                    this.localeTree.put(parent, countries);
                }
                countries.add(locale);
                i.remove();
            }
            i = locales.iterator();
            while (i.hasNext()) {
                locale = (Locale)i.next();
                parent = new Locale(locale.getLanguage(), locale.getCountry());
                ArrayList<Locale> variants = (ArrayList<Locale>)this.localeTree.get(parent);
                if (variants == null) {
                    variants = new ArrayList<Locale>();
                    this.localeTree.put(parent, variants);
                }
                variants.add(locale);
                i.remove();
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(null);
        }

        public Object[] getChildren(Object parentElement) {
            return this.localeTree.containsKey(parentElement) ? ((Collection)this.localeTree.get(parentElement)).toArray() : new Object[]{};
        }

        public Object getParent(Object element) {
            if (element instanceof Locale) {
                Locale locale = (Locale)element;
                if ("".equals(locale.getCountry())) {
                    return null;
                }
                if ("".equals(locale.getVariant())) {
                    return new Locale(locale.getLanguage());
                }
                return new Locale(locale.getLanguage(), locale.getCountry());
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.localeTree.containsKey(element);
        }

        public String getText(Object element) {
            if (element instanceof Locale) {
                Locale locale = (Locale)element;
                if ("".equals(locale.getCountry())) {
                    return locale.getDisplayLanguage();
                }
                if ("".equals(locale.getVariant())) {
                    return locale.getDisplayCountry();
                }
                return locale.getDisplayVariant();
            }
            return null;
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
    }
}

