/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.project.IApplicationDesign;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.eclipse.vtp.desktop.ui.app.editor.ApplicationNavigator2;
import org.eclipse.vtp.desktop.ui.app.editor.ApplicationViewer;
import org.eclipse.vtp.desktop.ui.app.editor.IconicAppPage;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelException;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelPage;
import org.eclipse.vtp.desktop.ui.app.layouts.AspectRatioLayout;
import org.eclipse.vtp.desktop.ui.app.layouts.AspectRatioLayoutData;
import org.eclipse.vtp.desktop.ui.app.viewers.ApplicationPageViewer;
import org.eclipse.vtp.desktop.ui.app.wizards.AddDesignCanvasWizard;
import org.eclipse.vtp.desktop.ui.app.wizards.RenameDesignCanvasWizard;
import org.eclipse.vtp.framework.media.binding.MediaBinding;
import org.eclipse.vtp.framework.media.xml.MediaXML;
import org.w3c.dom.Document;

public class ApplicationEditor
extends EditorPart
implements ApplicationModel.ModificationListener {
    private IApplicationDesign application;
    private IApplicationProject project;
    private boolean isModified = false;
    private ApplicationModel model;
    private ApplicationViewer modelViewer;
    private CoolBar flowTools = null;
    private Composite flowEditor = null;
    private Map sessionsByBrandNames = new HashMap();
    private Composite pageSelector = null;
    private NewCanvasAction newCanvasAction = new NewCanvasAction();
    private RenameCanvasAction renameCanvasAction = new RenameCanvasAction();
    private ClearCanvasAction clearCanvasAction = new ClearCanvasAction();
    private DeleteCanvasAction deleteCanvasAction = new DeleteCanvasAction();
    private List iconicPages = new ArrayList();
    private ApplicationOutlinePage outlinePage = new ApplicationOutlinePage();
    private Font font = null;
    private Color darkBlue;
    private Color lightBlue;
    private IconicAppPage selectedPage = null;
    static /* synthetic */ Class class$0;

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
        Document document = this.model.getCurrentDOM();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer t = factory.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            t.transform(new DOMSource(document), new StreamResult(baos));
            this.application.write((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            this.model.clearModified();
            this.isModified = false;
            this.firePropertyChange(257);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        monitor.done();
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        FileEditorInput fileInput = (FileEditorInput)input;
        try {
            this.project = DesktopCorePlugin.convertToApplication((IProject)fileInput.getFile().getProject());
            this.application = this.project.getApplicationDesign();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(this.application.read());
            this.model = new ApplicationModel();
            this.model.setApplication(this.application);
            this.model.setProject(this.project);
            try {
                this.model.load(document);
            }
            catch (ApplicationModelException ame) {
                this.model = new ApplicationModel();
                throw new PartInitException("Could not load editor.", (Throwable)ame);
            }
            this.model.addModificationListener(this);
            this.sessionsByBrandNames.clear();
            Iterator i = this.project.getBrandSet().getBrands().iterator();
            while (i.hasNext()) {
                IBrand brand = (IBrand)i.next();
                MediaBinding mediaBinding = MediaXML.loadBinding((Source)new StreamSource(brand.getBinding().read()));
                this.sessionsByBrandNames.put(brand.getName(), mediaBinding);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new PartInitException("Could not create part", e);
        }
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    public boolean isDirty() {
        return this.isModified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        FontData fontData = new FontData();
        fontData.setHeight(7);
        fontData.setName("Arial");
        this.font = new Font((Device)Display.getCurrent(), fontData);
        this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
        this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ApplicationEditor.this.font.dispose();
                ApplicationEditor.this.darkBlue.dispose();
                ApplicationEditor.this.lightBlue.dispose();
            }
        });
        final Composite all = new Composite(parent, 0);
        FormLayout allLayout = new FormLayout();
        all.setLayout((Layout)allLayout);
        all.setBackground(all.getDisplay().getSystemColor(1));
        all.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setAntialias(1);
                Color b = e.gc.getBackground();
                e.gc.setBackground(ApplicationEditor.this.darkBlue);
                e.gc.fillRectangle(0, 0, all.getSize().x, ((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().y);
                e.gc.fillRectangle(0, ((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().y, ((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().x, 50 - ((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().y);
                e.gc.fillRectangle(0, all.getSize().y - 11, all.getSize().x, 10);
                e.gc.fillRectangle(0, all.getSize().y - 31, ((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().x, 20);
                e.gc.setBackground(e.widget.getDisplay().getSystemColor(1));
                e.gc.fillArc(110, ((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().y, (((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().x - 110) * 2, (50 - ((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().y) * 2, 180, -90);
                e.gc.fillArc(110, all.getSize().y - 51, (((ApplicationEditor)ApplicationEditor.this).flowEditor.getLocation().x - 110) * 2, 40, 180, 90);
                e.gc.setBackground(b);
            }
        });
        final ScrolledComposite sc = new ScrolledComposite(all, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        FormData pageSelectorData = new FormData();
        pageSelectorData.left = new FormAttachment(0, 0);
        pageSelectorData.top = new FormAttachment(0, 50);
        pageSelectorData.bottom = new FormAttachment(100, -30);
        pageSelectorData.right = new FormAttachment(0, 110);
        sc.setLayoutData((Object)pageSelectorData);
        this.pageSelector = new Composite((Composite)sc, 0);
        sc.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Point s = sc.getSize();
                Point p = ApplicationEditor.this.pageSelector.computeSize(s.x, -1, true);
                if (p.y > s.y) {
                    Point cs = new Point(10, p.y);
                    sc.setMinSize(cs);
                } else {
                    sc.setMinSize(p);
                }
            }
        });
        sc.setContent((Control)this.pageSelector);
        this.pageSelector.setBackground(this.lightBlue);
        GridLayout pageSelectorLayout = new GridLayout(1, false);
        pageSelectorLayout.marginHeight = 10;
        pageSelectorLayout.marginWidth = 10;
        pageSelectorLayout.verticalSpacing = 10;
        this.pageSelector.setLayout((Layout)pageSelectorLayout);
        this.flowTools = new CoolBar(all, 256);
        this.flowTools.setBackground(this.darkBlue);
        FormData flowToolsData = new FormData();
        flowToolsData.left = new FormAttachment((Control)sc, 30);
        flowToolsData.top = new FormAttachment(0, 5);
        flowToolsData.right = new FormAttachment(100, 0);
        this.flowTools.setLayoutData((Object)flowToolsData);
        this.flowEditor = new Composite(all, 0);
        FormData flowEditorData = new FormData();
        flowEditorData.left = new FormAttachment((Control)sc, 30);
        flowEditorData.top = new FormAttachment((Control)this.flowTools, 5);
        flowEditorData.right = new FormAttachment(100, 0);
        flowEditorData.bottom = new FormAttachment(100, -10);
        this.flowEditor.setLayoutData((Object)flowEditorData);
        this.flowEditor.setLayout((Layout)new FillLayout());
        CoolItem ci = new CoolItem(this.flowTools, 0);
        ToolBar tb = new ToolBar((Composite)this.flowTools, 0x800000);
        tb.setBackground(this.darkBlue);
        this.createFlowEditor(tb, this.flowEditor);
        tb.pack();
        Point p = tb.getSize();
        ci.setControl((Control)tb);
        p = ci.computeSize(p.x, p.y);
        ci.setSize(p);
        List pages = this.model.listPages();
        int q = 0;
        while (q < pages.size()) {
            IconicAppPage mainPage = new IconicAppPage(this.pageSelector, 0, (ApplicationModelPage)pages.get(q));
            GridData mainPageData = new GridData(768);
            mainPage.setLayoutData(mainPageData);
            if (q == 0) {
                mainPage.setSelected(true);
                this.selectedPage = mainPage;
            }
            mainPage.addSelectionListener(new IconicAppPage.SelectionListener(){

                public void selected(IconicAppPage page) {
                    if (ApplicationEditor.this.selectedPage != page) {
                        ApplicationEditor.this.selectedPage.setSelected(false);
                        ApplicationEditor.this.selectedPage = page;
                    }
                    ApplicationEditor.this.modelViewer.setCurrentPage(ApplicationEditor.this.selectedPage.getPage());
                    ApplicationEditor.this.outlinePage.setCurrentPage(ApplicationEditor.this.selectedPage.getPage());
                }
            });
            mainPage.addContextAction((IAction)this.newCanvasAction);
            mainPage.addContextAction((IAction)this.renameCanvasAction);
            mainPage.addContextAction((IAction)this.clearCanvasAction);
            if (pages.size() > 1) {
                mainPage.addContextAction((IAction)this.deleteCanvasAction);
            }
            this.iconicPages.add(mainPage);
            ++q;
        }
        this.hookContextMenu();
    }

    private void createFlowEditor(ToolBar tb, Composite parent) {
        final ToolItem pointerToolItem = new ToolItem(tb, 16);
        pointerToolItem.setToolTipText("Pointer Tool");
        pointerToolItem.setImage(ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_POINTER_TOOL"));
        pointerToolItem.setSelection(true);
        final ToolItem lineToolItem = new ToolItem(tb, 16);
        lineToolItem.setToolTipText("Connector Tool");
        lineToolItem.setImage(ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_LINE_TOOL"));
        pointerToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (pointerToolItem.getSelection()) {
                    ApplicationEditor.this.modelViewer.setCurrentTool(0);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        lineToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (lineToolItem.getSelection()) {
                    ApplicationEditor.this.modelViewer.setCurrentTool(1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        List pages = this.model.listPages();
        this.modelViewer = new ApplicationViewer((ApplicationModelPage)pages.get(0));
        this.modelViewer.setFont(this.font);
        this.modelViewer.setDialogFrameColor(this.darkBlue);
        this.modelViewer.setDialogSideBarColor(this.lightBlue);
        this.modelViewer.setSessionsByBrandNames(this.sessionsByBrandNames);
        this.modelViewer.createPartControl(parent);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.pageSelector);
        this.pageSelector.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.newCanvasAction);
    }

    public void setFocus() {
        this.modelViewer.setFocus();
    }

    public IApplicationDesign getApplication() {
        return this.application;
    }

    public void setApplication(IApplicationDesign application) {
        this.application = application;
    }

    public void modified(ApplicationModel editor) {
        this.isModified = true;
        this.firePropertyChange(257);
    }

    public void statusUpdated(ApplicationModel editor) {
    }

    public class ApplicationOutlinePage
    implements IContentOutlinePage {
        private List selectionListeners = new ArrayList();
        Composite mainComp;
        SashForm mainSplit;
        AspectRatioLayoutData aspectRatio = null;
        ApplicationNavigator2 navigator = null;

        public void createControl(Composite parent) {
            this.mainComp = new Composite(parent, 0);
            this.mainComp.setLayout((Layout)new FillLayout());
            this.mainSplit = new SashForm(this.mainComp, 512);
            Composite navigatorComp = new Composite((Composite)this.mainSplit, 0);
            navigatorComp.setLayout((Layout)new AspectRatioLayout());
            this.navigator = new ApplicationNavigator2();
            if (ApplicationEditor.this.model.listPages().size() > 0) {
                this.navigator.setPage((ApplicationModelPage)ApplicationEditor.this.model.listPages().get(0));
            }
            this.navigator.createPartControl(navigatorComp);
            this.aspectRatio = new AspectRatioLayoutData();
            this.aspectRatio.sourceWidth = 1;
            this.aspectRatio.sourceHeight = 1;
            this.navigator.getControl().setLayoutData((Object)this.aspectRatio);
            ScrolledComposite scroll = new ScrolledComposite((Composite)this.mainSplit, 768);
            ApplicationPageViewer pageViewer = new ApplicationPageViewer((Composite)scroll, 0);
            scroll.setContent((Control)pageViewer);
            pageViewer.setApplicationModel(ApplicationEditor.this.model);
            scroll.setMinSize(pageViewer.computeSize(-1, -1));
            scroll.setAlwaysShowScrollBars(false);
            scroll.setExpandHorizontal(true);
            scroll.setExpandVertical(true);
        }

        public Control getControl() {
            return this.mainComp;
        }

        public void dispose() {
        }

        public void setActionBars(IActionBars actionBars) {
        }

        public void setFocus() {
        }

        public ISelection getSelection() {
            return null;
        }

        public void setSelection(ISelection selection) {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionListeners.remove(listener);
            this.selectionListeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionListeners.remove(listener);
        }

        public void setCurrentPage(ApplicationModelPage page) {
            if (this.navigator != null) {
                this.navigator.setPage(page);
            }
        }
    }

    public class ClearCanvasAction
    extends Action {
        public ClearCanvasAction() {
            this.setText("Clear Design Canvas");
        }

        public void run() {
            MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
            confirmationDialog.setMessage("Are you sure you want to delete all elements contained in this page?");
            int result = confirmationDialog.open();
            if (result == 64) {
                ApplicationEditor.this.selectedPage.getPage().clear();
            }
        }
    }

    public class DeleteCanvasAction
    extends Action {
        public DeleteCanvasAction() {
            this.setText("Delete Design Canvas");
        }

        public void run() {
            MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
            confirmationDialog.setMessage("Are you sure you want to delete this page and all the elements it contains?");
            int result = confirmationDialog.open();
            if (result == 64) {
                ApplicationEditor.this.selectedPage.getPage().delete();
                ApplicationEditor.this.iconicPages.remove((Object)ApplicationEditor.this.selectedPage);
                ApplicationEditor.this.selectedPage.dispose();
                ApplicationEditor.this.selectedPage = (IconicAppPage)((Object)ApplicationEditor.this.iconicPages.get(0));
                ApplicationEditor.this.selectedPage.setSelected(true);
                if (ApplicationEditor.this.iconicPages.size() == 1) {
                    ApplicationEditor.this.selectedPage.removeContextAction((IAction)this);
                }
            }
        }
    }

    public class NewCanvasAction
    extends Action {
        public NewCanvasAction() {
            this.setText("New Design Canvas");
        }

        public void run() {
            AddDesignCanvasWizard adcw = new AddDesignCanvasWizard(ApplicationEditor.this.model);
            WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)adcw);
            int result = wd.open();
            if (result == 0) {
                ApplicationModelPage amp = ApplicationEditor.this.model.addPage(adcw.getCanvasName());
                IconicAppPage mainPage = new IconicAppPage(ApplicationEditor.this.pageSelector, 0, amp);
                GridData mainPageData = new GridData(768);
                mainPage.setLayoutData(mainPageData);
                ApplicationEditor.this.selectedPage.setSelected(false);
                ApplicationEditor.this.selectedPage = mainPage;
                mainPage.addSelectionListener(new IconicAppPage.SelectionListener(this){
                    final /* synthetic */ NewCanvasAction this$1;
                    {
                        this.this$1 = newCanvasAction;
                    }

                    public void selected(IconicAppPage page) {
                        if (ApplicationEditor.access$2(NewCanvasAction.access$0(this.this$1)) != page) {
                            ApplicationEditor.access$2(NewCanvasAction.access$0(this.this$1)).setSelected(false);
                            ApplicationEditor.access$3(NewCanvasAction.access$0(this.this$1), page);
                        }
                        ApplicationEditor.access$4(NewCanvasAction.access$0(this.this$1)).setCurrentPage(ApplicationEditor.access$2(NewCanvasAction.access$0(this.this$1)).getPage());
                    }
                });
                ApplicationEditor.this.selectedPage.setSelected(true);
                ApplicationEditor.this.iconicPages.add(mainPage);
                mainPage.addContextAction((IAction)ApplicationEditor.this.newCanvasAction);
                mainPage.addContextAction((IAction)ApplicationEditor.this.clearCanvasAction);
                mainPage.addContextAction((IAction)ApplicationEditor.this.deleteCanvasAction);
                ApplicationEditor.this.pageSelector.layout(true);
            }
        }

        static /* synthetic */ ApplicationEditor access$0(NewCanvasAction newCanvasAction) {
            return newCanvasAction.ApplicationEditor.this;
        }
    }

    public class RenameCanvasAction
    extends Action {
        public RenameCanvasAction() {
            this.setText("Rename Design Canvas");
        }

        public void run() {
            RenameDesignCanvasWizard adcw = new RenameDesignCanvasWizard(ApplicationEditor.this.selectedPage.getPage());
            WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)adcw);
            int result = wd.open();
            if (result == 0) {
                ApplicationEditor.this.selectedPage.getPage().setName(adcw.getCanvasName());
            }
        }
    }
}

