/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelPage;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.GraphicUpdateEvent;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.GraphicUpdateListener;

public class ApplicationNavigator
implements PaintListener,
GraphicUpdateListener {
    private Canvas canvas = null;
    private Map resourceMap = new HashMap();
    private ApplicationModelPage page;
    private Color white = null;

    public ApplicationNavigator() {
    }

    public ApplicationNavigator(ApplicationModelPage page) {
        this.page = page;
        page.addGraphicListener(this);
    }

    public ApplicationModelPage getPage() {
        return this.page;
    }

    public void setPage(ApplicationModelPage page) {
        if (this.page != null) {
            this.page.removeGraphicListener(this);
        }
        this.page = page;
        page.addGraphicListener(this);
        if (this.canvas != null) {
            this.canvas.redraw();
        }
    }

    public void createPartControl(Composite parent) {
        this.white = (Color)this.resourceMap.get("COLOR_WHITE");
        if (this.white == null) {
            this.white = new Color((Device)Display.getCurrent(), 255, 255, 255);
            this.resourceMap.put("COLOR_WHITE", this.white);
        }
        this.canvas = new Canvas(parent, 0);
        this.canvas.setToolTipText(this.page.getName());
        this.canvas.setBackground(this.white);
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ApplicationNavigator.this.white.dispose();
            }
        });
        if (parent instanceof MouseListener) {
            this.canvas.addMouseListener((MouseListener)parent);
        }
    }

    public Control getControl() {
        return this.canvas;
    }

    public void paintControl(PaintEvent e) {
        if (this.page != null) {
            Point graphSize = this.page.getGraphSize();
            GC g = e.gc;
            g.setAntialias(1);
            double scaleW = (double)this.canvas.getSize().x / (double)graphSize.x;
            double scaleH = (double)this.canvas.getSize().y / (double)graphSize.y;
            double scale = Math.min(scaleW, scaleH);
            if (scale >= 1.0) {
                scale = 1.0;
            }
            Transform tr = new Transform((Device)this.canvas.getDisplay(), (float)scale, 0.0f, 0.0f, (float)scale, (float)(((double)this.canvas.getSize().x - (double)graphSize.x * scale) / 2.0), (float)(((double)this.canvas.getSize().y - (double)graphSize.y * scale) / 2.0));
            g.setTransform(tr);
            this.page.paint(new Point(0, 0), new Point(graphSize.x, graphSize.y), g, 731);
            tr.dispose();
        }
    }

    public void graphicUpdate(GraphicUpdateEvent e) {
        if (e.finished) {
            this.canvas.redraw();
        }
    }
}

