/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.localdata.ILocalDomain;
import org.eclipse.vtp.desktop.core.localdata.ILocalModule;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroup;
import org.eclipse.vtp.desktop.core.localdata.ILocalModuleGroupVersion;
import org.eclipse.vtp.desktop.core.localdata.ILocalVendor;
import org.eclipse.vtp.desktop.core.project.IApplicationDesign;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.ISupportedLanguage;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelException;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelObject;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelPage;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationStartElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationTransferElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComparisonElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.DatabaseQueryElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.DisconnectElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.FieldElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.ForEachElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.ModuleElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.PlayPromptElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.RecordingElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.SubdialogElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.TransferElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.VariableAssignmentElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeEntryElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.WormholeExitElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.StructureListener;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ApplicationModel {
    private IApplicationDesign application;
    private IApplicationProject project;
    private boolean isModified = false;
    private List modificationListeners;
    private List structureListeners;
    private List elements;
    private List connectors;
    boolean hasWarnings = false;
    boolean hasErrors = false;
    boolean validating = true;
    public Map resourceMap = new HashMap();
    private List languages = new ArrayList();
    private List wormholes = new ArrayList();
    private List pages = new ArrayList();
    boolean validationInProgress = false;

    public ApplicationModel() {
        this.modificationListeners = new ArrayList();
        this.elements = new ArrayList();
        this.connectors = new ArrayList();
        this.structureListeners = new ArrayList();
    }

    public ApplicationModelPage addPage(String pageName) {
        ApplicationModelPage amp = new ApplicationModelPage(this, pageName);
        this.pages.add(amp);
        this.isModified = true;
        this.fireModified();
        return amp;
    }

    public void deletePage(ApplicationModelPage page) {
        this.pages.remove(page);
        this.isModified = true;
        this.fireModified();
    }

    public Element getElement(String id) {
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Element el = (Element)iterator.next();
            if (!el.getId().equals(id)) continue;
            return el;
        }
        return null;
    }

    public Connector getConnector(String id) {
        Iterator iterator = this.connectors.iterator();
        while (iterator.hasNext()) {
            Connector con = (Connector)iterator.next();
            if (!con.getId().equals(id)) continue;
            return con;
        }
        return null;
    }

    public Document getCurrentDOM() {
        ByteArrayInputStream bais = new ByteArrayInputStream(ApplicationUIPlugin.baseApplicationTemplate.getBytes());
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            org.w3c.dom.Element applicationElement = document.getDocumentElement();
            org.w3c.dom.Element elementsElement = (org.w3c.dom.Element)applicationElement.getElementsByTagName("elements").item(0);
            org.w3c.dom.Element destinationsElement = (org.w3c.dom.Element)applicationElement.getElementsByTagName("destinations").item(0);
            org.w3c.dom.Element pagesElement = (org.w3c.dom.Element)applicationElement.getElementsByTagName("ui-pages").item(0);
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                Element el = (Element)obj;
                el.writeToDocument(elementsElement);
            }
            iterator = this.connectors.iterator();
            while (iterator.hasNext()) {
                Connector con = (Connector)iterator.next();
                con.writeToDocument(destinationsElement);
            }
            iterator = this.pages.iterator();
            while (iterator.hasNext()) {
                ((ApplicationModelPage)iterator.next()).writeToDocument(pagesElement);
            }
            return document;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setApplication(IApplicationDesign application) {
        this.application = application;
    }

    public IApplicationDesign getApplication() {
        return this.application;
    }

    public void setProject(IApplicationProject project) {
        this.project = project;
        List ps = project.getSupportedLanguages();
        LinkedList<ISupportedLanguage> langResults = new LinkedList<ISupportedLanguage>();
        int i = 0;
        while (i < ps.size()) {
            langResults.add((ISupportedLanguage)ps.get(i));
            ++i;
        }
        this.languages = new ArrayList(langResults);
    }

    public IApplicationProject getProject() {
        return this.project;
    }

    /*
     * Unable to fully structure code
     */
    public void load(Document document) throws ApplicationModelException {
        applicationElement = document.getDocumentElement();
        try {
            tempWorms = new ArrayList<org.w3c.dom.Element>();
            componentElements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)applicationElement, (String)"elements"));
            i = 0;
            while (i < componentElements.length) {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        block29: {
                                                            block28: {
                                                                block27: {
                                                                    block25: {
                                                                        block26: {
                                                                            id = componentElements[i].getAttribute("instance-id");
                                                                            name = componentElements[i].getAttribute("name");
                                                                            el = null;
                                                                            if (!componentElements[i].getTagName().equals("module")) break block25;
                                                                            moduleName = componentElements[i].getAttribute("module");
                                                                            moduleGroupVersion = componentElements[i].getAttribute("version-number");
                                                                            moduleGroupName = componentElements[i].getAttribute("module-group");
                                                                            vendorName = componentElements[i].getAttribute("vendor");
                                                                            localModule = this.findModule(vendorName, moduleGroupName, moduleGroupVersion, moduleName);
                                                                            if (localModule == null) break block26;
                                                                            mel = new ModuleElement(id, name, localModule);
                                                                            settingElements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)componentElements[i], (String)"settings"));
                                                                            s = 0;
                                                                            while (s < settingElements.length) {
                                                                                settingName = settingElements[s].getAttribute("name");
                                                                                settingValue = settingElements[s].getAttribute("value");
                                                                                mel.setProperty(settingName, settingValue);
                                                                                ++s;
                                                                            }
                                                                            try {
                                                                                configElements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)componentElements[i], (String)"configuration"));
                                                                                s = 0;
                                                                                while (s < configElements.length) {
                                                                                    settingName = configElements[s].getAttribute("name");
                                                                                    settingValue = configElements[s].getAttribute("value");
                                                                                    mel.setConfiguration(settingName, settingValue);
                                                                                    ++s;
                                                                                }
                                                                            }
                                                                            catch (Exception ex) {
                                                                                ex.printStackTrace();
                                                                            }
                                                                            el = mel;
                                                                            ** GOTO lbl128
                                                                        }
                                                                        throw new ApplicationModelException("Could not find module.\r\n\tVendor: " + vendorName + "\r\n\tGroup: " + moduleGroupName + "\r\n\tModule: " + moduleName + "\r\n\tVersion: " + moduleGroupVersion);
                                                                    }
                                                                    if (!componentElements[i].getTagName().equals("app-start")) break block27;
                                                                    el = new ApplicationStartElement(id);
                                                                    el.readSettings(componentElements[i]);
                                                                    ** GOTO lbl128
                                                                }
                                                                if (!componentElements[i].getTagName().equals("assign")) break block28;
                                                                el = new VariableAssignmentElement(id, name);
                                                                ((VariableAssignmentElement)el).readSettings(componentElements[i]);
                                                                ** GOTO lbl128
                                                            }
                                                            if (!componentElements[i].getTagName().equals("transfer")) break block29;
                                                            target = componentElements[i].getAttribute("target");
                                                            targetType = componentElements[i].getAttribute("target-type");
                                                            if (targetType.equals("")) {
                                                                target = componentElements[i].getAttribute("dn");
                                                                targetType = "0";
                                                            }
                                                            el = new TransferElement(id, name, target);
                                                            ((TransferElement)el).setTargetType(Integer.parseInt(targetType));
                                                            ** GOTO lbl128
                                                        }
                                                        if (!componentElements[i].getTagName().equals("subdialog")) break block30;
                                                        el = new SubdialogElement(id, name);
                                                        ((SubdialogElement)el).readSettings(componentElements[i]);
                                                        ** GOTO lbl128
                                                    }
                                                    if (!componentElements[i].getTagName().equals("app-transfer")) break block31;
                                                    dn = componentElements[i].getAttribute("dn");
                                                    el = new ApplicationTransferElement(id, name, dn);
                                                    ** GOTO lbl128
                                                }
                                                if (!componentElements[i].getTagName().equals("disconnect")) break block32;
                                                promptName = componentElements[i].getAttribute("promptName");
                                                el = new DisconnectElement(id, promptName);
                                                ** GOTO lbl128
                                            }
                                            if (!componentElements[i].getTagName().equals("prompt")) break block33;
                                            el = new PlayPromptElement(id, name);
                                            ((PlayPromptElement)el).readSettings(componentElements[i]);
                                            ** GOTO lbl128
                                        }
                                        if (!componentElements[i].getTagName().equals("database-query")) break block34;
                                        el = new DatabaseQueryElement(id, name);
                                        ((DatabaseQueryElement)el).readSettings(componentElements[i]);
                                        ** GOTO lbl128
                                    }
                                    if (!componentElements[i].getTagName().equals("web-service-call")) break block35;
                                    el = new WebServiceCallElement(id, name);
                                    ((WebServiceCallElement)el).readSettings(componentElements[i]);
                                    ** GOTO lbl128
                                }
                                if (!componentElements[i].getTagName().equals("for-each")) break block36;
                                el = new ForEachElement(id, name);
                                ((ForEachElement)el).readSettings(componentElements[i]);
                                ** GOTO lbl128
                            }
                            if (!componentElements[i].getTagName().equals("field")) break block37;
                            el = new FieldElement(id, name);
                            ((FieldElement)el).readSettings(componentElements[i]);
                            ** GOTO lbl128
                        }
                        if (!componentElements[i].getTagName().equals("recording")) break block38;
                        el = new RecordingElement(id, name);
                        ((RecordingElement)el).readSettings(componentElements[i]);
                        ** GOTO lbl128
                    }
                    if (!componentElements[i].getTagName().equals("menu")) break block39;
                    menuElement = new MenuElement(id, name);
                    bargein = componentElements[i].getAttribute("barge-in");
                    menuElement.setBarginEnabled(bargein.equals("true"));
                    menuElement.readSettings(componentElements[i]);
                    el = menuElement;
                    ** GOTO lbl128
                }
                if (componentElements[i].getTagName().equals("worm-hole-entry")) {
                    tempWorms.add(componentElements[i]);
                } else {
                    if (componentElements[i].getTagName().equals("worm-hole-exit")) {
                        el = new WormholeExitElement(id, name);
                        this.wormholes.add(el);
                    } else if (componentElements[i].getTagName().equals("comparison")) {
                        el = new ComparisonElement(id, name);
                        ((ComparisonElement)el).readSettings(componentElements[i]);
                    }
lbl128:
                    // 18 sources

                    if (el != null) {
                        this.elements.add(el);
                        el.setModel(this);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < tempWorms.size()) {
                ele = (org.w3c.dom.Element)tempWorms.get(i);
                id = ele.getAttribute("instance-id");
                name = ele.getAttribute("name");
                el = new WormholeEntryElement(id, name);
                wee = this.getWormhole(ele.getAttribute("exit-id"));
                this.elements.add(el);
                if (wee != null) {
                    wee.addWormholeEntry(el);
                }
                el.setModel(this);
                ++i;
            }
            destinations = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)applicationElement, (String)"destinations"));
            i = 0;
            while (i < destinations.length) {
                connectorId = destinations[i].getAttribute("instance-id");
                origin = null;
                destination = null;
                nodeList = destinations[i].getElementsByTagName("origin");
                originElement = (org.w3c.dom.Element)nodeList.item(0);
                moduleId = originElement.getAttribute("instance-id");
                iterator = this.elements.iterator();
                while (iterator.hasNext()) {
                    el = (Element)iterator.next();
                    if (!el.getId().equals(moduleId)) continue;
                    origin = (ConnectorOrigin)el;
                }
                nodeList = destinations[i].getElementsByTagName("target");
                targetElement = (org.w3c.dom.Element)nodeList.item(0);
                componentId = targetElement.getAttribute("instance-id");
                iterator = this.elements.iterator();
                while (iterator.hasNext()) {
                    el = (Element)iterator.next();
                    if (!el.getId().equals(componentId)) continue;
                    destination = (ConnectorDestination)el;
                }
                connector = new Connector(connectorId, origin, destination);
                connector.readSettings(destinations[i]);
                destination.addIncomingConnector(connector);
                if (origin != destination) {
                    endPointReferenceElements = XMLUtilities.getElementsOfNodeList((NodeList)originElement.getElementsByTagName("endpoint-reference"));
                    r = 0;
                    while (r < endPointReferenceElements.length) {
                        endPointName = endPointReferenceElements[r].getAttribute("end-point-name");
                        connector.addExitPoint(origin.getRecord(endPointName));
                        ++r;
                    }
                    hookPointReferenceElements = XMLUtilities.getElementsOfNodeList((NodeList)originElement.getElementsByTagName("hookpoint-reference"));
                    r = 0;
                    while (r < hookPointReferenceElements.length) {
                        endPointName = hookPointReferenceElements[r].getAttribute("end-point-name");
                        connector.addExitPoint(origin.getRecord(endPointName));
                        ++r;
                    }
                    this.connectors.add(connector);
                }
                ++i;
            }
            pageElements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((org.w3c.dom.Element)applicationElement, (String)"ui-pages"));
            i = 0;
            while (i < pageElements.length) {
                page = new ApplicationModelPage(this);
                page.load(pageElements[i]);
                this.pages.add(page);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.elements.size() < 1) {
            ase = new ApplicationStartElement();
            this.elements.add(ase);
        } else {
            this.validateStatus();
        }
    }

    private ILocalModule findModule(String vendorName, String moduleGroupName, String moduleGroupVersion, String moduleName) {
        ILocalDomain localDomain = DesktopCorePlugin.getDefault().getLocalDomain();
        ILocalVendor localVendor = localDomain.getVendorByName(vendorName);
        if (localVendor == null) {
            return null;
        }
        ILocalModuleGroup localModuleGroup = localVendor.getModuleGroupByName(moduleGroupName);
        if (localModuleGroup == null) {
            return null;
        }
        ILocalModuleGroupVersion localVersion = localModuleGroup.getVersionByNumber(moduleGroupVersion);
        if (localVersion == null) {
            return null;
        }
        ILocalModule localModule = localVersion.getModuleByName(moduleName);
        return localModule;
    }

    public String getDefaultLanguage() {
        return this.languages.get(0).toString();
    }

    public String[] getLanguages() {
        String[] strings = new String[this.languages.size()];
        int i = 0;
        while (i < strings.length) {
            strings[i] = this.languages.get(i).toString();
            ++i;
        }
        return strings;
    }

    public boolean isDirty() {
        return this.isModified;
    }

    public String getName() {
        return String.valueOf(this.project.getApplicationName()) + " " + this.project.getApplicationVersion();
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void deleteConnector(Connector connector) {
        this.deleteConnector(connector, true);
    }

    public void deleteConnector(Connector connector, boolean validate) {
        this.connectors.remove(connector);
        connector.getDestination().removeIncomingConnector(connector);
        connector.delete();
        this.dispatchObjectRemoved(connector);
        if (validate) {
            this.validateStatus();
        }
    }

    public void deleteElement(Element element) {
        this.deleteElement(element, true);
    }

    public void deleteElement(Element element, boolean validate) {
        ArrayList<Connector> removeList = new ArrayList<Connector>();
        Iterator iterator = this.connectors.iterator();
        while (iterator.hasNext()) {
            Connector con = (Connector)iterator.next();
            if (con.getOrigin() == element) {
                removeList.add(con);
                continue;
            }
            if (con.getDestination() != element) continue;
            removeList.add(con);
        }
        iterator = removeList.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            this.deleteConnector((Connector)obj, false);
        }
        if (element instanceof WormholeExitElement) {
            this.wormholes.remove(element);
        }
        this.elements.remove(element);
        element.delete();
        this.dispatchObjectRemoved(element);
        if (validate) {
            this.validateStatus();
        }
    }

    public List listPages() {
        return this.pages;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
        this.validateStatus();
    }

    public void validateStatus() {
        boolean inheritValidation = this.validationInProgress;
        this.validationInProgress = true;
        this.hasErrors = false;
        this.hasWarnings = false;
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Element el = (Element)iterator.next();
            if (this.validating) {
                el.validateStatus();
                this.hasErrors |= el.hasError();
                this.hasWarnings |= el.hasWarning();
                continue;
            }
            el.clearStatus();
        }
        if (!inheritValidation) {
            this.validationInProgress = false;
        }
    }

    public void addElement(Element element) {
        element.setModel(this);
        if (element instanceof WormholeExitElement) {
            this.wormholes.add(element);
        }
        this.elements.add(element);
        this.isModified = true;
        this.fireModified();
        this.dispatchObjectAdded(element);
        this.validateStatus();
    }

    public void addConnector(Connector connector) {
        this.connectors.add(connector);
        connector.getDestination().addIncomingConnector(connector);
        this.isModified = true;
        this.fireModified();
        this.dispatchObjectAdded(connector);
        this.validateStatus();
    }

    public List listWormholes() {
        return Collections.unmodifiableList(this.wormholes);
    }

    public WormholeExitElement getWormhole(String id) {
        int i = 0;
        while (i < this.wormholes.size()) {
            if (((WormholeExitElement)this.wormholes.get(i)).getId().equals(id)) {
                return (WormholeExitElement)this.wormholes.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void addModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
        this.modificationListeners.add(listener);
    }

    public void removeModificationListener(ModificationListener listener) {
        this.modificationListeners.remove(listener);
    }

    private void fireModified() {
        Iterator iterator = this.modificationListeners.iterator();
        while (iterator.hasNext()) {
            ((ModificationListener)iterator.next()).modified(this);
        }
    }

    public void addStructureListener(StructureListener listener) {
        this.structureListeners.remove(listener);
        this.structureListeners.add(listener);
    }

    public void removeStructureListener(StructureListener listener) {
        this.structureListeners.remove(listener);
    }

    private void dispatchObjectAdded(final ApplicationModelObject target) {
        new Thread(new Runnable(){

            public void run() {
                Iterator iterator = ApplicationModel.this.structureListeners.iterator();
                while (iterator.hasNext()) {
                    ((StructureListener)iterator.next()).objectAdded(target);
                }
            }
        }).start();
    }

    private void dispatchObjectRemoved(ApplicationModelObject target) {
        Iterator iterator = this.structureListeners.iterator();
        while (iterator.hasNext()) {
            ((StructureListener)iterator.next()).objectRemoved(target);
        }
    }

    void fireInternalModified() {
        this.isModified = true;
        this.fireModified();
    }

    public void clearModified() {
        this.isModified = false;
        this.fireModified();
    }

    public static interface ModificationListener {
        public void modified(ApplicationModel var1);
    }
}

