/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.VariableAssignmentElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.VariableDeclaration;
import org.eclipse.vtp.desktop.ui.shared.dialogs.FramedDialog;

public class AssignmentVariablesPropertyPanel
extends ComponentPropertiesPanel {
    List declarations;
    List variables;
    TableViewer variableViewer;
    Button addButton;
    Button removeButton;
    TextCellEditor valueEditor;
    VariableAssignmentElement assignElement;

    public AssignmentVariablesPropertyPanel(VariableAssignmentElement assignElement, List declarations) {
        super("Variables");
        this.assignElement = assignElement;
        this.declarations = declarations;
        this.variables = new ArrayList();
        assignElement.getVariables("Continue", this.variables, new ArrayList());
    }

    public void createControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Table variableTable = new Table(parent, 67588);
        variableTable.setHeaderVisible(true);
        TableColumn newColumn = new TableColumn(variableTable, 0);
        newColumn.setText("New");
        newColumn.setWidth(15);
        TableColumn nameColumn = new TableColumn(variableTable, 0);
        nameColumn.setText("Variable Name");
        nameColumn.setWidth(150);
        TableColumn typeColumn = new TableColumn(variableTable, 0);
        typeColumn.setText("Type");
        typeColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(variableTable, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        GridData gd = new GridData(1040);
        gd.verticalSpan = 2;
        gd.widthHint = 520;
        gd.heightHint = 200;
        variableTable.setLayoutData((Object)gd);
        this.valueEditor = new TextCellEditor((Composite)variableTable);
        this.variableViewer = new TableViewer(variableTable);
        this.variableViewer.setColumnProperties(new String[]{"New", "Name", "Type", "Value"});
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[3] = this.valueEditor;
        this.variableViewer.setCellEditors(cellEditorArray);
        this.variableViewer.setCellModifier((ICellModifier)new ValueCellModifier());
        this.variableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.variableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.variableViewer.setInput((Object)this);
        this.variableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AssignmentVariablesPropertyPanel.this.variableViewer.getSelection().isEmpty()) {
                    AssignmentVariablesPropertyPanel.this.removeButton.setEnabled(false);
                    return;
                }
                HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
                int i = 0;
                while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                    VariableDeclaration vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                    vdm.put(vd.name, vd);
                    ++i;
                }
                Variable v = (Variable)((IStructuredSelection)AssignmentVariablesPropertyPanel.this.variableViewer.getSelection()).getFirstElement();
                AssignmentVariablesPropertyPanel.this.removeButton.setEnabled(vdm.get(v.getName()) != null);
            }
        });
        this.addButton = new Button(parent, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(770));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewVariableDialog nvd = new NewVariableDialog(AssignmentVariablesPropertyPanel.this.addButton.getShell());
                if (nvd.open() == 32) {
                    AssignmentVariablesPropertyPanel.this.declarations.add(new VariableDeclaration(nvd.name, nvd.multiplicity, nvd.type, 0, null));
                    FieldType ft = FieldType.custom((String)nvd.type, (AssignmentVariablesPropertyPanel.this.assignElement.isObject(nvd.type) && nvd.multiplicity != 1 ? 1 : 0) != 0, (nvd.multiplicity == 1 ? 1 : 0) != 0, (int)0);
                    Variable v = new Variable(nvd.name, ft);
                    AssignmentVariablesPropertyPanel.this.assignElement.buildObjectFields(v);
                    AssignmentVariablesPropertyPanel.this.variables.add(v);
                    AssignmentVariablesPropertyPanel.this.variableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText("Clear");
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(2));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Variable v = (Variable)((IStructuredSelection)AssignmentVariablesPropertyPanel.this.variableViewer.getSelection()).getFirstElement();
                VariableDeclaration vd = null;
                int i = 0;
                while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                    vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                    if (vd.name.equals(v.getName())) break;
                    vd = null;
                    ++i;
                }
                if (vd != null) {
                    AssignmentVariablesPropertyPanel.this.declarations.remove(vd);
                    AssignmentVariablesPropertyPanel.this.variables = new ArrayList();
                    AssignmentVariablesPropertyPanel.this.assignElement.getVariables("Continue", AssignmentVariablesPropertyPanel.this.variables, new ArrayList());
                    HashMap<String, Variable> vdm = new HashMap<String, Variable>();
                    int i2 = 0;
                    while (i2 < AssignmentVariablesPropertyPanel.this.variables.size()) {
                        Variable va = (Variable)AssignmentVariablesPropertyPanel.this.variables.get(i2);
                        vdm.put(va.getName(), va);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                        VariableDeclaration nvd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i2);
                        if (vdm.get(nvd.name) == null) {
                            FieldType ft = FieldType.custom((String)nvd.type, (AssignmentVariablesPropertyPanel.this.assignElement.isObject(nvd.type) && nvd.multiplicity != 1 ? 1 : 0) != 0, (nvd.multiplicity == 1 ? 1 : 0) != 0, (int)0);
                            Variable vx = new Variable(nvd.name, ft);
                            AssignmentVariablesPropertyPanel.this.assignElement.buildObjectFields(vx);
                            AssignmentVariablesPropertyPanel.this.variables.add(vx);
                        }
                        ++i2;
                    }
                }
                AssignmentVariablesPropertyPanel.this.variableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void save() {
        this.assignElement.setVariableDeclarations(this.declarations);
    }

    public class NewVariableDialog
    extends FramedDialog {
        Color darkBlue;
        Color lightBlue;
        Text nameField;
        Combo multiplicityCombo;
        Combo typeCombo;
        String name;
        int multiplicity;
        String type;

        public NewVariableDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("New Variable");
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            Button okButton = new Button(buttons, 0x800000);
            okButton.setText("Ok");
            okButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ NewVariableDialog this$1;
                {
                    this.this$1 = newVariableDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 0x800000);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ NewVariableDialog this$1;
                {
                    this.this$1 = newVariableDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public void okPressed() {
            this.name = this.nameField.getText();
            this.multiplicity = this.multiplicityCombo.getSelectionIndex();
            this.type = this.typeCombo.getItem(this.typeCombo.getSelectionIndex());
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.setReturnCode(256);
            this.close();
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ NewVariableDialog this$1;
                {
                    this.this$1 = newVariableDialog;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.this$1.darkBlue.dispose();
                    this.this$1.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            parent.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label(parent, 0);
            nameLabel.setText("Name");
            nameLabel.setBackground(parent.getBackground());
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            nameLabel.setLayoutData((Object)gd);
            this.nameField = new Text(parent, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.nameField.setLayoutData((Object)gd);
            Label typeLabel = new Label(parent, 0);
            typeLabel.setText("Type");
            typeLabel.setBackground(parent.getBackground());
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            typeLabel.setLayoutData((Object)gd);
            this.multiplicityCombo = new Combo(parent, 2060);
            this.multiplicityCombo.add("One Of");
            this.multiplicityCombo.add("Array Of");
            this.multiplicityCombo.select(0);
            this.multiplicityCombo.setLayoutData((Object)new GridData());
            this.typeCombo = new Combo(parent, 2060);
            this.typeCombo.add("String");
            this.typeCombo.add("Number");
            this.typeCombo.add("Decimal");
            this.typeCombo.add("Boolean");
            this.typeCombo.add("DateTime");
            List businessObjects = ((IApplicationProject)AssignmentVariablesPropertyPanel.this.assignElement.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < businessObjects.size()) {
                IBusinessObject ibo = (IBusinessObject)businessObjects.get(i);
                this.typeCombo.add(ibo.getName());
                ++i;
            }
            this.typeCombo.select(0);
            this.typeCombo.setLayoutData((Object)new GridData(768));
        }
    }

    public class ValueCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            Variable vd;
            return property.equals("Value") && !(vd = (Variable)element).getType().isArray() && (vd.getType().getTypeName().equals("String") || vd.getType().getTypeName().equals("Number") || vd.getType().getTypeName().equals("Decimal") || vd.getType().getTypeName().equals("Boolean") || vd.getType().getTypeName().equals("DataTime"));
        }

        public Object getValue(Object element, String property) {
            HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                VariableDeclaration vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(vd.name, vd);
                ++i;
            }
            Variable vd = (Variable)element;
            if (property.equals("Value")) {
                return vdm.get(vd.getName()) == null ? "" : (((VariableDeclaration)vdm.get((Object)vd.getName())).value == null ? "" : ((VariableDeclaration)vdm.get((Object)vd.getName())).value);
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            Object vd;
            HashMap<String, Object> vdm = new HashMap<String, Object>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(((VariableDeclaration)vd).name, vd);
                ++i;
            }
            TableItem ti = (TableItem)element;
            vd = (Variable)ti.getData();
            VariableDeclaration varDec = (VariableDeclaration)vdm.get(((ObjectDefinition)vd).getName());
            if (varDec == null) {
                varDec = new VariableDeclaration(((ObjectDefinition)vd).getName(), ((ObjectDefinition)vd).getType().isArray() ? 1 : 0, ((ObjectDefinition)vd).getType().getTypeName(), 0, null);
                AssignmentVariablesPropertyPanel.this.declarations.add(varDec);
            }
            if (property.equals("Value")) {
                varDec.valueType = 0;
                varDec.value = (String)value;
                AssignmentVariablesPropertyPanel.this.variableViewer.refresh(true);
            }
        }
    }

    public class VariableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return AssignmentVariablesPropertyPanel.this.variables.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class VariableLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            HashMap<String, VariableDeclaration> vdm = new HashMap<String, VariableDeclaration>();
            int i = 0;
            while (i < AssignmentVariablesPropertyPanel.this.declarations.size()) {
                VariableDeclaration vd = (VariableDeclaration)AssignmentVariablesPropertyPanel.this.declarations.get(i);
                vdm.put(vd.name, vd);
                ++i;
            }
            Variable vd = (Variable)element;
            if (columnIndex == 0) {
                if (vdm.get(vd.getName()) != null) {
                    return "*";
                }
                return "";
            }
            if (columnIndex == 1) {
                return vd.getName();
            }
            if (columnIndex == 2) {
                String ret = "";
                if (vd.getType().isArray()) {
                    ret = "Array Of ";
                }
                ret = String.valueOf(ret) + vd.getType().getTypeName();
                return ret;
            }
            if (columnIndex == 3 && !vd.getType().isArray() && (vd.getType().getTypeName().equals("String") || vd.getType().getTypeName().equals("Number") || vd.getType().getTypeName().equals("Decimal") || vd.getType().getTypeName().equals("Boolean") || vd.getType().getTypeName().equals("DataTime")) && vdm.get(vd.getName()) != null) {
                return ((VariableDeclaration)vdm.get((Object)vd.getName())).value;
            }
            return "N/A";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

