/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ApplicationModelObject;

public abstract class Element
extends ApplicationModelObject {
    private String name;
    boolean hasTodo = false;
    boolean hasWarning = false;
    boolean hasError = false;
    private ApplicationModel model;

    public Element(String name) {
        this.name = name;
    }

    public Element(String id, String name) {
        super(id);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.model != null) {
            this.model.fireInternalModified();
        }
    }

    public ApplicationModel getModel() {
        return this.model;
    }

    protected void setModel(ApplicationModel model) {
        this.model = model;
    }

    public boolean hasTodo() {
        return this.hasTodo;
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void setTodo(boolean hasTodo) {
        this.hasTodo = hasTodo;
    }

    public void setWarning(boolean hasWarning) {
        this.hasWarning = hasWarning;
    }

    public void setError(boolean hasError) {
        this.hasError = hasError;
    }

    public void clearStatus() {
        this.hasError = false;
        this.hasWarning = false;
        this.hasTodo = false;
    }

    public void validateStatus() {
        this.hasError = false;
        this.hasWarning = false;
        this.hasTodo = false;
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("name", this.name);
    }

    public String getTagName() {
        return "element";
    }

    public void delete() {
    }

    public List getPropertyPanels() {
        return new ArrayList();
    }

    public List getVariables() {
        return Collections.EMPTY_LIST;
    }

    public abstract MediaProvider getMediaProvider();
}

