/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScript;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptFieldObject;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorOrigin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.FieldGeneralPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.event.ConnectorOriginPathListener;
import org.eclipse.vtp.framework.media.library.MediaLibrary;

public class FieldElement
extends Element
implements ConnectorDestination,
ConnectorOrigin {
    List incomingConnectors;
    ConnectorRecord next = new ConnectorRecord(this, "Next", ConnectorRecord.EXIT_POINT);
    ConnectorRecord inputFailureNoMatch = new ConnectorRecord(this, "error.input.nomatch", ConnectorRecord.ERROR_POINT);
    ConnectorRecord inputFailureNoInput = new ConnectorRecord(this, "error.input.noinput", ConnectorRecord.ERROR_POINT);
    MediaProvider mp = new FieldMediaProvider();
    private List listeners = new ArrayList();
    String varName;
    boolean bargeIn = true;
    boolean hasTermDigit = true;
    String termDigit = "#";
    int terminationTimeout = 3;
    int interdigitTimeout = 3;
    boolean retriesSeparate = false;
    int noInputLimit = 2;
    int noMatchLimit = 2;
    int badInputLimit = 2;

    public FieldElement(String name) {
        super(name);
        this.incomingConnectors = new ArrayList();
    }

    public FieldElement(String id, String name) {
        super(id, name);
        this.incomingConnectors = new ArrayList();
    }

    public boolean isBargeIn() {
        return this.bargeIn;
    }

    public void setBargeIn(boolean bargeIn) {
        this.bargeIn = bargeIn;
    }

    public int getInterdigitTimeout() {
        return this.interdigitTimeout;
    }

    public void setInterdigitTimeout(int interdigitTimeout) {
        this.interdigitTimeout = interdigitTimeout;
    }

    public String getTermDigit() {
        return this.termDigit;
    }

    public void setTermDigit(String termDigit) {
        this.termDigit = termDigit;
    }

    public int getTerminationTimeout() {
        return this.terminationTimeout;
    }

    public void setTerminationTimeout(int terminationTimeout) {
        this.terminationTimeout = terminationTimeout;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public void setHasTermDigit(boolean hasTermDigit) {
        this.hasTermDigit = hasTermDigit;
    }

    public boolean hasTermDigit() {
        return this.hasTermDigit;
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public ConnectorRecord getRecord(String name) {
        if (name.equals("Next")) {
            return this.next;
        }
        if (name.equals("error.input.nomatch")) {
            return this.inputFailureNoMatch;
        }
        if (name.equals("error.input.noinput")) {
            return this.inputFailureNoInput;
        }
        return null;
    }

    public List getHooks() {
        return this.getFreeHooks();
    }

    public List getFreeHooks() {
        ArrayList freeExits = new ArrayList();
        return Collections.unmodifiableList(freeExits);
    }

    public List getExits() {
        return Collections.unmodifiableList(Arrays.asList(this.next, this.inputFailureNoMatch, this.inputFailureNoInput));
    }

    public List getFreeExits() {
        ArrayList<ConnectorRecord> freeExits = new ArrayList<ConnectorRecord>();
        if (this.next.getConnector() == null) {
            freeExits.add(this.next);
        }
        if (this.inputFailureNoMatch.getConnector() == null) {
            freeExits.add(this.inputFailureNoMatch);
        }
        if (this.inputFailureNoInput.getConnector() == null) {
            freeExits.add(this.inputFailureNoInput);
        }
        return Collections.unmodifiableList(freeExits);
    }

    public void validateStatus() {
        super.validateStatus();
        boolean isExitedFrom = false;
        boolean isErrorFrom = false;
        boolean hasErrorFrom = false;
        if (this.next.getConnector() != null) {
            isExitedFrom = true;
        }
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart(null) || this.varName == null || this.varName.equals("")) {
            this.setError(true);
        }
        if (!isErrorFrom && hasErrorFrom) {
            this.setTodo(true);
        }
        if (!isExitedFrom) {
            this.setWarning(true);
        }
    }

    public boolean hasPathToStart(List originPath) {
        if (originPath == null) {
            originPath = new ArrayList<FieldElement>();
        }
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("var-name", this.varName == null ? "" : this.varName);
        element.setAttribute("barge-in", Boolean.toString(this.bargeIn));
        element.setAttribute("has-term-digit", Boolean.toString(this.hasTermDigit));
        element.setAttribute("term-digit", this.termDigit);
        element.setAttribute("term-timeout", Integer.toString(this.terminationTimeout));
        element.setAttribute("inter-digit-timeout", Integer.toString(this.interdigitTimeout));
        element.setAttribute("retry-strategy", this.retriesSeparate ? "separate" : "combined");
        element.setAttribute("no-input-limit", Integer.toString(this.noInputLimit));
        element.setAttribute("no-match-limit", Integer.toString(this.noMatchLimit));
        element.setAttribute("bad-input-limit", Integer.toString(this.badInputLimit));
    }

    public void readSettings(org.w3c.dom.Element element) {
        this.varName = element.getAttribute("var-name");
        if (!element.getAttribute("barge-in").equals("")) {
            this.bargeIn = Boolean.valueOf(element.getAttribute("barge-in"));
        }
        if (!element.getAttribute("has-term-digit").equals("")) {
            this.hasTermDigit = Boolean.valueOf(element.getAttribute("has-term-digit"));
        }
        if (!element.getAttribute("term-digit").equals("")) {
            this.termDigit = element.getAttribute("term-digit");
        }
        if (!element.getAttribute("term-timeout").equals("")) {
            try {
                this.terminationTimeout = Integer.parseInt(element.getAttribute("term-timeout"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("inter-digit-timeout").equals("")) {
            try {
                this.interdigitTimeout = Integer.parseInt(element.getAttribute("inter-digit-timeout"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("retry-strategy").equals("")) {
            this.retriesSeparate = element.getAttribute("retry-strategy").equals("separate");
        }
        if (!element.getAttribute("no-input-limit").equals("")) {
            try {
                this.noInputLimit = Integer.parseInt(element.getAttribute("no-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("no-match-limit").equals("")) {
            try {
                this.noMatchLimit = Integer.parseInt(element.getAttribute("no-match-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!element.getAttribute("bad-input-limit").equals("")) {
            try {
                this.badInputLimit = Integer.parseInt(element.getAttribute("bad-input-limit"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public MediaProvider getMediaProvider() {
        return this.mp;
    }

    public String getTagName() {
        return "field";
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new FieldGeneralPropertiesPanel(this));
        return ret;
    }

    public List getIncomingVariables() {
        ArrayList ret = new ArrayList();
        ArrayList visited = new ArrayList();
        this.getVariables("", ret, visited);
        return ret;
    }

    public void getVariables(String endPointName, List variables, List visited) {
        if (!visited.contains(this.getRecord(endPointName))) {
            visited.add(this.getRecord(endPointName));
            int i = 0;
            while (i < this.incomingConnectors.size()) {
                Connector con = (Connector)this.incomingConnectors.get(i);
                int c = 0;
                while (c < con.getExitCodes().size()) {
                    ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                    con.getOrigin().getVariables(cr.getName(), variables, visited);
                    ++c;
                }
                ++i;
            }
            if (endPointName.equals("Next") && this.varName != null && !this.varName.equals("")) {
                FieldType ft = FieldType.STRING;
                Variable v = new Variable(this.varName, ft);
                this.buildObjectFields(v);
                variables.add(v);
            }
        }
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }

    public void buildObjectFields(ObjectDefinition def) {
        if (def.getType().isObject()) {
            List bos = ((IApplicationProject)this.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
            int i = 0;
            while (i < bos.size()) {
                IBusinessObject ibo = (IBusinessObject)bos.get(i);
                if (ibo.getName().equals(def.getType().getTypeName())) {
                    List fields = ibo.getFields();
                    int f = 0;
                    while (f < fields.size()) {
                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                        this.buildObjectFields(def.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false)));
                        ++f;
                    }
                }
                ++i;
            }
        } else if (def.getType().isArray()) {
            def.addField(new ObjectField("numberOfItems", FieldType.NUMBER, true));
        } else if (def.getType().equals("String")) {
            def.addField(new ObjectField("length", FieldType.NUMBER, true));
        }
    }

    public boolean isObject(String typeName) {
        return !typeName.equals("String") && !typeName.equals("Number") && !typeName.equals("Decimal") && !typeName.equals("Boolean") && !typeName.equals("DateTime");
    }

    public void addPathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
        this.listeners.add(l);
    }

    public void removePathListener(ConnectorOriginPathListener l) {
        this.listeners.remove(l);
    }

    public class FieldMediaProvider
    implements MediaProvider {
        private MediaScript script = new MediaScript(this){
            final /* synthetic */ FieldMediaProvider this$1;
            {
                this.this$1 = fieldMediaProvider;
            }

            public List getDialogs() {
                ArrayList<MediaScriptFieldObject> ret = new ArrayList<MediaScriptFieldObject>();
                ret.add(new MediaScriptFieldObject("Field", this.this$1.getProviderType(), this.this$1.getId()));
                return ret;
            }
        };

        public String getId() {
            return FieldElement.this.getId();
        }

        public String getProviderType() {
            return "builtin.field.1_0_0_0";
        }

        public String getProviderName() {
            return "Field";
        }

        public boolean hasMediaContent() {
            return true;
        }

        public boolean hasSharedContent() {
            return false;
        }

        public boolean hasDefaultLibrary() {
            return false;
        }

        public MediaScript getScript() {
            return this.script;
        }

        public MediaLibrary getDefaultMediaLibrary() {
            return null;
        }
    }
}

