/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.UIElementRenderer;

public class IconicElementRenderer
implements UIElementRenderer {
    Image icon = ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_WORMHOLE_ENTRY_BIG");

    public Rectangle calculateBounds(UIElement element, GC font) {
        Point np = font.stringExtent(element.getName());
        int nw = np.x;
        int nh = np.y + 8 + this.icon.getBounds().height;
        int rw = Math.max(nw / 2 + 2, this.icon.getBounds().width / 2 + 2);
        int rh = nh / 2 + 2;
        element.upperLeft = new java.awt.Point(element.x - rw, element.y - rh);
        element.lowerRight = new java.awt.Point(element.x + rw, element.y + rh);
        return new Rectangle(element.upperLeft.x, element.upperLeft.y, element.lowerRight.x - element.upperLeft.x, element.lowerRight.y - element.upperLeft.y);
    }

    public java.awt.Point getIncursionPoint(UIElement element, int x, int y) {
        if (element.upperLeft == null || element.lowerRight == null) {
            return null;
        }
        java.awt.Point p1 = new java.awt.Point(x, y);
        java.awt.Point p2 = new java.awt.Point(element.x, element.y);
        java.awt.Point ret = element.getIntersection(p1, p2, new java.awt.Point(element.upperLeft.x, element.upperLeft.y), new java.awt.Point(element.lowerRight.x, element.upperLeft.y));
        if (ret == null) {
            ret = element.getIntersection(p1, p2, new java.awt.Point(element.lowerRight.x, element.upperLeft.y), new java.awt.Point(element.lowerRight.x, element.lowerRight.y));
        }
        if (ret == null) {
            ret = element.getIntersection(p1, p2, new java.awt.Point(element.upperLeft.x, element.upperLeft.y), new java.awt.Point(element.upperLeft.x, element.lowerRight.y));
        }
        if (ret == null) {
            ret = element.getIntersection(p1, p2, new java.awt.Point(element.upperLeft.x, element.lowerRight.y), new java.awt.Point(element.lowerRight.x, element.lowerRight.y));
        }
        return ret;
    }

    public void paint(UIElement element, Map resourceMap, GC g, int style) {
        Color blue = element.getColor(resourceMap, "COLOR_BLUE", 0, 0, 255);
        Color black = element.getColor(resourceMap, "COLOR_BLACK", 0, 0, 0);
        Color foreground = g.getForeground();
        g.drawImage(this.icon, (element.getLowerRight().x - element.getUpperLeft().x - this.icon.getBounds().width) / 2 + element.getUpperLeft().x, element.getUpperLeft().y + 2);
        if (element.isSelected()) {
            g.setForeground(blue);
            g.drawRectangle(element.upperLeft.x, element.upperLeft.y, element.lowerRight.x - element.upperLeft.x, element.lowerRight.y - element.upperLeft.y);
        } else {
            g.setForeground(black);
        }
        Point np = g.stringExtent(element.getName());
        g.drawString(element.getName(), (element.getLowerRight().x - element.getUpperLeft().x - np.x) / 2 + element.getUpperLeft().x, element.getLowerRight().y - np.y - 2, true);
        if (element.getElement().hasError()) {
            g.drawImage(UIElement.errorIcon, element.lowerRight.x - UIElement.errorIcon.getImageData().width, element.upperLeft.y);
        } else if (element.getElement().hasWarning()) {
            g.drawImage(UIElement.warningIcon, element.lowerRight.x - UIElement.warningIcon.getImageData().width, element.upperLeft.y);
        } else if (element.getElement().hasTodo()) {
            g.drawImage(UIElement.todoIcon, element.lowerRight.x - UIElement.todoIcon.getImageData().width, element.upperLeft.y);
        }
        g.setForeground(foreground);
    }

    public void paintShadows(UIElement element, Map resourceMap, GC g) {
    }
}

