/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.ui.app.editor.DynamicMenuOption;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScript;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptDynamicMenuObject;
import org.eclipse.vtp.desktop.ui.app.editor.MediaScriptDynamicMenuOptionList;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuChoice;
import org.eclipse.vtp.desktop.ui.app.editor.model.MenuElement;
import org.eclipse.vtp.framework.media.library.MediaLibrary;

public class MenuMediaProvider
implements MediaProvider {
    MenuElement menu;
    private MediaScript script = null;
    Map dmoMap = new HashMap();

    public MenuMediaProvider(MenuElement menu) {
        this.menu = menu;
        this.script = new MediaScript(){
            MediaScriptDynamicMenuObjectImpl impl;
            {
                this.impl = new MediaScriptDynamicMenuObjectImpl();
            }

            public List getDialogs() {
                ArrayList<MediaScriptDynamicMenuObjectImpl> ret = new ArrayList<MediaScriptDynamicMenuObjectImpl>();
                ret.add(this.impl);
                return ret;
            }
        };
    }

    public String getId() {
        return this.menu.getId();
    }

    public String getProviderType() {
        return "buildin.menu.1_0_0_0";
    }

    public String getProviderName() {
        return this.menu.getName();
    }

    public boolean hasMediaContent() {
        return true;
    }

    public boolean hasSharedContent() {
        return false;
    }

    public boolean hasDefaultLibrary() {
        return false;
    }

    public MediaScript getScript() {
        return this.script;
    }

    public MediaLibrary getDefaultMediaLibrary() {
        return null;
    }

    public class DynamicMenuOptionImpl
    extends DynamicMenuOption {
        MenuChoice menuChoice;

        public DynamicMenuOptionImpl(MenuChoice menuChoice) {
            super(menuChoice.getOptionName(), 0);
            this.menuChoice = null;
            this.menuChoice = menuChoice;
        }

        public boolean isSilent() {
            return this.menuChoice.isSilent();
        }

        public void setDTMF(int dtmf) {
            this.dtmf = dtmf;
            this.menuChoice.setDtmf(Integer.toString(dtmf));
        }

        public void setSilent(boolean silent) {
            this.menuChoice.setSilent(silent);
        }
    }

    public class MediaScriptDynamicMenuObjectImpl
    extends MediaScriptDynamicMenuObject {
        public MediaScriptDynamicMenuObjectImpl() {
            super("Menu", MenuMediaProvider.this.getProviderType(), MenuMediaProvider.this.getId(), new ArrayList());
            List choices = MenuMediaProvider.this.menu.getChoices();
            int i = 0;
            while (i < choices.size()) {
                DynamicMenuOptionImpl dmoi = (DynamicMenuOptionImpl)MenuMediaProvider.this.dmoMap.get(choices.get(i));
                if (dmoi == null) {
                    dmoi = new DynamicMenuOptionImpl((MenuChoice)choices.get(i));
                    MenuMediaProvider.this.dmoMap.put(choices.get(i), dmoi);
                }
                this.menuOptions.add(dmoi);
                ++i;
            }
        }

        public MediaScriptDynamicMenuOptionList getOptions(String brand) {
            return new MediaScriptDynamicMenuOptionListImpl(brand);
        }
    }

    public class MediaScriptDynamicMenuOptionListImpl
    implements MediaScriptDynamicMenuOptionList {
        List menuOptions = new ArrayList();
        String brandName = null;

        public MediaScriptDynamicMenuOptionListImpl(String brandName) {
            this.brandName = brandName;
            List ol = MenuMediaProvider.this.menu.getChoicesByBrand(brandName);
            int i = 0;
            while (i < ol.size()) {
                this.menuOptions.add((DynamicMenuOptionImpl)MenuMediaProvider.this.dmoMap.get((MenuChoice)ol.get(i)));
                ++i;
            }
        }

        public List getOptions() {
            return Collections.unmodifiableList(this.menuOptions);
        }

        public DynamicMenuOption addOption(String name, int dtmf, boolean silent) {
            MenuChoice choice = new MenuChoice(name, Integer.toString(dtmf), silent);
            DynamicMenuOptionImpl dmoi = (DynamicMenuOptionImpl)MenuMediaProvider.this.dmoMap.get(choice = MenuMediaProvider.this.menu.addChoice(this.brandName, choice));
            if (dmoi == null) {
                dmoi = new DynamicMenuOptionImpl(choice);
                MenuMediaProvider.this.dmoMap.put(choice, dmoi);
            }
            this.menuOptions.add(dmoi);
            return dmoi;
        }

        public void removeOption(DynamicMenuOption option) {
            if (this.menuOptions.remove(option)) {
                MenuMediaProvider.this.menu.removeChoice(this.brandName, ((DynamicMenuOptionImpl)option).menuChoice);
                MenuMediaProvider.this.dmoMap.remove(((DynamicMenuOptionImpl)option).menuChoice);
            }
        }

        public void moveOptionUp(DynamicMenuOption option) {
            MenuMediaProvider.this.menu.moveChoiceUp(this.brandName, ((DynamicMenuOptionImpl)option).menuChoice);
            int index = this.menuOptions.indexOf(option);
            if (index > 0) {
                this.menuOptions.remove(index);
                this.menuOptions.add(index - 1, option);
            }
        }

        public void moveOptionDown(DynamicMenuOption option) {
            MenuMediaProvider.this.menu.moveChoiceDown(this.brandName, ((DynamicMenuOptionImpl)option).menuChoice);
            System.out.println("moving down: " + option.getName());
            int index = this.menuOptions.indexOf(option);
            System.out.println("index: " + index);
            if (index < this.menuOptions.size() - 1) {
                this.menuOptions.remove(index);
                this.menuOptions.add(index + 1, option);
            }
        }
    }
}

