/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ModuleElement;

public class ModuleSettingsPropertiesPanel
extends ComponentPropertiesPanel {
    ModuleElement me;
    Label settingsLabel;
    TableViewer settingsTable;
    HashMap map = new HashMap();

    public ModuleSettingsPropertiesPanel(ModuleElement me) {
        super("Settings");
        this.me = me;
        this.map.putAll(me.properties);
    }

    public void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new FormLayout());
        this.settingsLabel = new Label(comp, 0);
        this.settingsLabel.setText("Settings");
        this.settingsLabel.setBackground(comp.getBackground());
        FormData settingsLabelData = new FormData();
        settingsLabelData.left = new FormAttachment(0, 10);
        settingsLabelData.top = new FormAttachment(0, 10);
        settingsLabelData.right = new FormAttachment(100, -10);
        this.settingsLabel.setLayoutData((Object)settingsLabelData);
        Table baseTable = new Table(comp, 68100);
        baseTable.setLinesVisible(true);
        baseTable.setHeaderVisible(true);
        TableColumn keyColumn = new TableColumn(baseTable, 16384);
        keyColumn.setResizable(true);
        keyColumn.setText("Key");
        keyColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(baseTable, 16384);
        valueColumn.setResizable(true);
        valueColumn.setText("Value");
        valueColumn.setWidth(150);
        this.settingsTable = new TableViewer(baseTable);
        this.settingsTable.setColumnProperties(new String[]{"Key", "Value"});
        this.settingsTable.setContentProvider((IContentProvider)new SettingsContentProvider());
        this.settingsTable.setLabelProvider((IBaseLabelProvider)new SettingsLabelProvider());
        TextCellEditor textEditor = new TextCellEditor((Composite)baseTable);
        this.settingsTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)baseTable), textEditor});
        this.settingsTable.setCellModifier((ICellModifier)new SettingsCellModifier());
        this.settingsTable.setInput((Object)this);
        FormData baseTableData = new FormData();
        baseTableData.left = new FormAttachment(0, 10);
        baseTableData.top = new FormAttachment((Control)this.settingsLabel, 10);
        baseTableData.right = new FormAttachment(100, -10);
        baseTableData.bottom = new FormAttachment(100, -10);
        baseTable.setLayoutData((Object)baseTableData);
    }

    public void save() {
        this.me.properties.putAll((Map<?, ?>)this.map);
    }

    public class SettingsCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return property.equals("Value");
        }

        public Object getValue(Object element, String property) {
            return property.equals("Value") ? ((Map.Entry)element).getValue() : "";
        }

        public void modify(Object element, String property, Object value) {
            if (property.equals("Value")) {
                ((Map.Entry)((TableItem)element).getData()).setValue(value);
                ModuleSettingsPropertiesPanel.this.settingsTable.refresh(true);
            }
        }
    }

    public class SettingsContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return ModuleSettingsPropertiesPanel.this.map.entrySet().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class SettingsLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Map.Entry entry = (Map.Entry)element;
            if (columnIndex == 0) {
                return (String)entry.getKey();
            }
            return (String)entry.getValue();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

