/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.ui.app.editor.MediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.BlankMediaProvider;
import org.eclipse.vtp.desktop.ui.app.editor.model.Connector;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorDestination;
import org.eclipse.vtp.desktop.ui.app.editor.model.ConnectorRecord;
import org.eclipse.vtp.desktop.ui.app.editor.model.Element;
import org.eclipse.vtp.desktop.ui.app.editor.model.TransferPropertiesPanel;

public class TransferElement
extends Element
implements ConnectorDestination {
    private String target;
    private int targetType = 0;
    private List incomingConnectors;
    private MediaProvider mediaProvider;

    public TransferElement(String dn) {
        super("Transfer: " + dn);
        this.target = dn;
        this.incomingConnectors = new ArrayList();
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Transfer", "buildin.genesys.transfer.1_0_0_0");
    }

    public TransferElement(String id, String name, String dn) {
        super(id, name);
        this.target = dn;
        this.incomingConnectors = new ArrayList();
        this.mediaProvider = new BlankMediaProvider(this.getId(), "Transfer", "buildin.genesys.transfer.1_0_0_0");
    }

    public void validateStatus() {
        super.validateStatus();
        if (this.incomingConnectors.size() < 1 || !this.hasPathToStart()) {
            this.setError(true);
        }
    }

    public boolean hasPathToStart() {
        ArrayList<TransferElement> originPath = new ArrayList<TransferElement>();
        originPath.add(this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (!originPath.contains(connector.getOrigin()) && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String dn) {
        this.target = dn;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public void setTargetType(int targetType) {
        this.targetType = targetType;
    }

    public String getTagName() {
        return "transfer";
    }

    public void writeAttributes(org.w3c.dom.Element element) {
        super.writeAttributes(element);
        element.setAttribute("target", this.target);
        element.setAttribute("target-type", Integer.toString(this.targetType));
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
        this.validateStatus();
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.validateStatus();
    }

    public MediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public List getPropertyPanels() {
        List ret = super.getPropertyPanels();
        ret.add(new TransferPropertiesPanel(this));
        return ret;
    }

    public List getVariables() {
        ArrayList ret = new ArrayList();
        ArrayList listed = new ArrayList();
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            Connector con = (Connector)this.incomingConnectors.get(i);
            int c = 0;
            while (c < con.getExitCodes().size()) {
                ConnectorRecord cr = (ConnectorRecord)con.getExitCodes().get(c);
                con.getOrigin().getVariables(cr.getName(), ret, listed);
                ++c;
            }
            ++i;
        }
        return ret;
    }
}

