/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editor.model;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectField;
import org.eclipse.vtp.desktop.core.project.IWebService;
import org.eclipse.vtp.desktop.core.project.IWebServiceOperation;
import org.eclipse.vtp.desktop.core.project.IWebServicePort;
import org.eclipse.vtp.desktop.ui.app.ApplicationUIPlugin;
import org.eclipse.vtp.desktop.ui.app.editor.model.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectDefinition;
import org.eclipse.vtp.desktop.ui.app.editor.model.ObjectField;
import org.eclipse.vtp.desktop.ui.app.editor.model.Variable;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallElement;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallSettingsListener;
import org.eclipse.vtp.desktop.ui.app.editor.model.WebServiceCallSettingsStructure;
import org.eclipse.vtp.desktop.ui.shared.dialogs.FramedDialog;

public class WebServiceCallOutputPropertiesPanel
extends ComponentPropertiesPanel
implements WebServiceCallSettingsListener {
    private final WebServiceCallElement callElement;
    private final WebServiceCallSettingsStructure settings;
    TableViewer mappingTableViewer;
    ObjectDefinition currentObject;
    ValueCellEditor valueCellEditor;
    List incomingVariables = null;

    public WebServiceCallOutputPropertiesPanel(WebServiceCallElement wsce, WebServiceCallSettingsStructure settings) {
        super("Output");
        this.callElement = wsce;
        this.settings = settings;
        settings.addSettingsListener(this);
        this.incomingVariables = this.callElement.getVariables();
    }

    public void createControls(Composite parent) {
        Table mappingTable = new Table(parent, 67588);
        mappingTable.setHeaderVisible(true);
        TableColumn businessObjectFieldColumn = new TableColumn(mappingTable, 0);
        businessObjectFieldColumn.setText("Business Object Field");
        businessObjectFieldColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(mappingTable, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        this.valueCellEditor = new ValueCellEditor((Composite)mappingTable);
        this.mappingTableViewer = new TableViewer(mappingTable);
        this.mappingTableViewer.setColumnProperties(new String[]{"Field", "Value"});
        this.mappingTableViewer.setCellModifier((ICellModifier)new MappingCellModifier());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.valueCellEditor;
        this.mappingTableViewer.setCellEditors(cellEditorArray);
        this.mappingTableViewer.setContentProvider((IContentProvider)new MappingContentProvider());
        this.mappingTableViewer.setLabelProvider((IBaseLabelProvider)new MappingLabelProvider());
        this.mappingTableViewer.setInput((Object)this);
        if (this.settings.targetVariableName != null && !this.settings.targetVariableName.equals("") && this.settings.targetVariableType != null && !this.settings.targetVariableType.equals("")) {
            if (this.settings.targetVariableExists) {
                String tname = this.settings.targetVariableName;
                String[] parts = tname.split("\\.");
                this.currentObject = this.findObjectDefinition(this.incomingVariables, parts[0]);
                int i = 1;
                while (i < parts.length) {
                    this.currentObject = this.findObjectDefinition(this.currentObject.getFields(), parts[i]);
                    if (this.currentObject == null) break;
                    ++i;
                }
                this.settings.dataMapping.clear();
                if (this.currentObject != null) {
                    if (this.currentObject.getType().isArray()) {
                        if (!this.currentObject.getType().isObject()) {
                            List list = this.settings.dataMapping;
                            WebServiceCallSettingsStructure webServiceCallSettingsStructure = this.settings;
                            webServiceCallSettingsStructure.getClass();
                            list.add(new WebServiceCallSettingsStructure.DataMapping(webServiceCallSettingsStructure, "Value", -1, null));
                        } else {
                            List businessObjects = ((IApplicationProject)this.callElement.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
                            int i2 = 0;
                            while (i2 < businessObjects.size()) {
                                IBusinessObject ibo = (IBusinessObject)businessObjects.get(i2);
                                if (ibo.getName().equals(this.settings.targetVariableType)) {
                                    List fields = ibo.getFields();
                                    int f = 0;
                                    while (f < fields.size()) {
                                        IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                                        List list = this.settings.dataMapping;
                                        WebServiceCallSettingsStructure webServiceCallSettingsStructure = this.settings;
                                        webServiceCallSettingsStructure.getClass();
                                        list.add(new WebServiceCallSettingsStructure.DataMapping(webServiceCallSettingsStructure, ibof.getName(), -1, null));
                                        ++f;
                                    }
                                }
                                ++i2;
                            }
                        }
                    } else if (this.currentObject.getType().isObject()) {
                        List fields = this.currentObject.getFields();
                        int i3 = 0;
                        while (i3 < fields.size()) {
                            ObjectField of = (ObjectField)fields.get(i3);
                            List list = this.settings.dataMapping;
                            WebServiceCallSettingsStructure webServiceCallSettingsStructure = this.settings;
                            webServiceCallSettingsStructure.getClass();
                            list.add(new WebServiceCallSettingsStructure.DataMapping(webServiceCallSettingsStructure, of.getName(), -1, null));
                            ++i3;
                        }
                    } else {
                        List list = this.settings.dataMapping;
                        WebServiceCallSettingsStructure webServiceCallSettingsStructure = this.settings;
                        webServiceCallSettingsStructure.getClass();
                        list.add(new WebServiceCallSettingsStructure.DataMapping(webServiceCallSettingsStructure, this.currentObject.getPath(), -1, null));
                    }
                }
            } else {
                boolean isObject = !this.settings.targetVariableType.equals("String") && !this.settings.targetVariableType.equals("Number") && !this.settings.targetVariableType.equals("Decimal") && !this.settings.targetVariableType.equals("Boolean") && !this.settings.targetVariableType.equals("DateTime");
                FieldType type = FieldType.custom((String)this.settings.targetVariableType, (boolean)isObject, (this.settings.targetMultiplicity == 1 ? 1 : 0) != 0, (int)1);
                this.currentObject = new Variable(this.settings.targetVariableName, type);
                if (isObject && this.settings.targetMultiplicity != 1) {
                    List businessObjects = ((IApplicationProject)this.callElement.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
                    int i = 0;
                    while (i < businessObjects.size()) {
                        IBusinessObject ibo = (IBusinessObject)businessObjects.get(i);
                        if (ibo.getName().equals(this.settings.targetVariableType)) {
                            List fields = ibo.getFields();
                            int f = 0;
                            while (f < fields.size()) {
                                IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                                this.currentObject.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false));
                                ++f;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        this.mappingTableViewer.refresh();
    }

    public ObjectDefinition findObjectDefinition(List posibilities, String name) {
        int i = 0;
        while (i < posibilities.size()) {
            ObjectDefinition od = (ObjectDefinition)posibilities.get(i);
            if (od.getName().equals(name)) {
                return od;
            }
            ++i;
        }
        return null;
    }

    public void save() {
    }

    public void sourceWebServiceChanged() {
    }

    public void targetChanged() {
        boolean targetIsArray;
        if (this.settings.targetVariableName == null || this.settings.targetVariableType == null || this.settings.targetVariableName.equals("") || this.settings.targetVariableType.equals("")) {
            this.currentObject = null;
            this.mappingTableViewer.refresh();
            return;
        }
        boolean bl = targetIsArray = this.settings.targetMultiplicity == 1;
        if (this.currentObject == null || !this.settings.targetVariableName.equals(this.currentObject.getPath()) || targetIsArray != this.currentObject.getType().isArray() || !this.settings.targetVariableType.equals(this.currentObject.getType().getTypeName())) {
            if (this.settings.targetVariableExists) {
                List incomingVariables = this.callElement.getVariables();
                int i = 0;
                while (i < incomingVariables.size()) {
                    Variable v = (Variable)incomingVariables.get(i);
                    if (v.getName().equals(this.settings.targetVariableName)) {
                        this.currentObject = v;
                    } else if (this.settings.targetVariableName != null && this.settings.targetVariableName.startsWith(v.getName())) {
                        List objectFields = v.getFields();
                        int f = 0;
                        while (f < objectFields.size()) {
                            ObjectField of = (ObjectField)objectFields.get(f);
                            if (of.getPath().equals(this.settings.targetVariableName)) {
                                this.currentObject = of;
                            }
                            ++f;
                        }
                    }
                    ++i;
                }
            } else {
                boolean isObject = !this.settings.targetVariableType.equals("String") && !this.settings.targetVariableType.equals("Number") && !this.settings.targetVariableType.equals("Decimal") && !this.settings.targetVariableType.equals("Boolean") && !this.settings.targetVariableType.equals("DateTime");
                FieldType type = FieldType.custom((String)this.settings.targetVariableType, (boolean)isObject, (this.settings.targetMultiplicity == 1 ? 1 : 0) != 0, (int)1);
                this.currentObject = new Variable(this.settings.targetVariableName, type);
                if (isObject && this.settings.targetMultiplicity != 1) {
                    List businessObjects = ((IApplicationProject)this.callElement.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
                    int i = 0;
                    while (i < businessObjects.size()) {
                        IBusinessObject ibo = (IBusinessObject)businessObjects.get(i);
                        if (ibo.getName().equals(this.settings.targetVariableType)) {
                            List fields = ibo.getFields();
                            int f = 0;
                            while (f < fields.size()) {
                                IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                                this.currentObject.addField(new ObjectField(ibof.getName(), ibof.getDataType(), false));
                                ++f;
                            }
                        }
                        ++i;
                    }
                }
            }
            this.settings.dataMapping.clear();
            if (this.currentObject.getType().isArray()) {
                if (!this.currentObject.getType().isObject()) {
                    List list = this.settings.dataMapping;
                    WebServiceCallSettingsStructure webServiceCallSettingsStructure = this.settings;
                    webServiceCallSettingsStructure.getClass();
                    list.add(new WebServiceCallSettingsStructure.DataMapping(webServiceCallSettingsStructure, "Value", -1, null));
                } else {
                    List businessObjects = ((IApplicationProject)this.callElement.getModel().getApplication().getProject()).getBusinessObjectSet().getBusinessObjects();
                    int i = 0;
                    while (i < businessObjects.size()) {
                        IBusinessObject ibo = (IBusinessObject)businessObjects.get(i);
                        if (ibo.getName().equals(this.settings.targetVariableType)) {
                            List fields = ibo.getFields();
                            int f = 0;
                            while (f < fields.size()) {
                                IBusinessObjectField ibof = (IBusinessObjectField)fields.get(f);
                                List list = this.settings.dataMapping;
                                WebServiceCallSettingsStructure webServiceCallSettingsStructure = this.settings;
                                webServiceCallSettingsStructure.getClass();
                                list.add(new WebServiceCallSettingsStructure.DataMapping(webServiceCallSettingsStructure, ibof.getName(), -1, null));
                                ++f;
                            }
                        }
                        ++i;
                    }
                }
            } else if (this.currentObject.getType().isObject()) {
                List fields = this.currentObject.getFields();
                int i = 0;
                while (i < fields.size()) {
                    ObjectField of = (ObjectField)fields.get(i);
                    List list = this.settings.dataMapping;
                    WebServiceCallSettingsStructure webServiceCallSettingsStructure = this.settings;
                    webServiceCallSettingsStructure.getClass();
                    list.add(new WebServiceCallSettingsStructure.DataMapping(webServiceCallSettingsStructure, of.getName(), -1, null));
                    ++i;
                }
            } else {
                List list = this.settings.dataMapping;
                WebServiceCallSettingsStructure webServiceCallSettingsStructure = this.settings;
                webServiceCallSettingsStructure.getClass();
                list.add(new WebServiceCallSettingsStructure.DataMapping(webServiceCallSettingsStructure, this.currentObject.getPath(), -1, null));
            }
            this.mappingTableViewer.refresh();
        }
    }

    public class MappingCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return property.equals("Value");
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            WebServiceCallOutputPropertiesPanel.this.mappingTableViewer.refresh();
        }
    }

    public class MappingContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (WebServiceCallOutputPropertiesPanel.this.currentObject == null) {
                return new Object[0];
            }
            return ((WebServiceCallOutputPropertiesPanel)WebServiceCallOutputPropertiesPanel.this).settings.dataMapping.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class MappingLabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            WebServiceCallSettingsStructure.DataMapping mapping = (WebServiceCallSettingsStructure.DataMapping)element;
            if (columnIndex == 0) {
                return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_TINY_SQUARE");
            }
            if (columnIndex == 1 && mapping.mappingType == 1) {
                return ApplicationUIPlugin.getDefault().getImageRegistry().get("ICON_DOMAIN");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            WebServiceCallSettingsStructure.DataMapping mapping = (WebServiceCallSettingsStructure.DataMapping)element;
            if (columnIndex == 0) {
                return mapping.fieldName;
            }
            if (mapping == null) {
                return null;
            }
            switch (mapping.mappingType) {
                case -1: {
                    return "No Change";
                }
                case 0: 
                case 1: {
                    return mapping.mappingValue;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class ValueCellEditor
    extends DialogCellEditor {
        Label iconLabel;
        Composite comp;

        public ValueCellEditor(Composite parent) {
            super(parent);
        }

        protected Control createContents(Composite cell) {
            return super.createContents(cell);
        }

        protected void updateContents(Object value) {
            WebServiceCallSettingsStructure.DataMapping mapping = (WebServiceCallSettingsStructure.DataMapping)value;
            if (mapping != null) {
                if (mapping.mappingType == -1) {
                    this.getDefaultLabel().setText("No Change");
                } else if (mapping.mappingType == 0) {
                    this.getDefaultLabel().setText(mapping.mappingValue);
                } else {
                    this.getDefaultLabel().setText(mapping.mappingValue);
                }
            } else {
                super.updateContents(value);
            }
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            ValueDialog vd = new ValueDialog(cellEditorWindow.getShell());
            vd.setValue((WebServiceCallSettingsStructure.DataMapping)this.getValue());
            vd.open();
            return this.getValue();
        }
    }

    public class ValueDialog
    extends FramedDialog {
        Button noChangeButton;
        Button databaseColumnButton;
        Button staticValueButton;
        Combo databaseColumnCombo;
        Text staticValueField;
        WebServiceCallSettingsStructure.DataMapping value;
        Color darkBlue;
        Color lightBlue;
        int originalMappingType;
        String originalMappingValue;

        public ValueDialog(Shell shell) {
            super(shell);
            this.setSideBarSize(40);
            this.setTitle("Select a value");
        }

        public void setValue(WebServiceCallSettingsStructure.DataMapping value) {
            this.value = value;
            this.originalMappingType = value.mappingType;
            this.originalMappingValue = value.mappingValue;
        }

        public void updateValue() {
            if (this.noChangeButton.getSelection()) {
                this.value.mappingType = -1;
                this.value.mappingValue = "";
            } else if (this.staticValueButton.getSelection()) {
                this.value.mappingType = 0;
                this.value.mappingValue = this.staticValueField.getText();
            } else {
                this.value.mappingType = 1;
                int selectionIndex = this.databaseColumnCombo.getSelectionIndex();
                this.value.mappingValue = selectionIndex < 0 ? "" : this.databaseColumnCombo.getItem(selectionIndex);
            }
        }

        protected void createButtonBar(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, true));
            Composite buttons = new Composite(parent, 0);
            buttons.setBackground(parent.getBackground());
            GridData buttonsData = new GridData(1808);
            buttonsData.horizontalAlignment = 131072;
            buttons.setLayoutData((Object)buttonsData);
            RowLayout rl = new RowLayout();
            rl.pack = false;
            rl.spacing = 5;
            buttons.setLayout((Layout)rl);
            Button okButton = new Button(buttons, 0x800000);
            okButton.setText("Ok");
            okButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ValueDialog this$1;
                {
                    this.this$1 = valueDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Button cancelButton = new Button(buttons, 0x800000);
            cancelButton.setText("Cancel");
            cancelButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ValueDialog this$1;
                {
                    this.this$1 = valueDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.cancelPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public void okPressed() {
            this.setReturnCode(32);
            this.close();
        }

        public void cancelPressed() {
            this.value.mappingType = this.originalMappingType;
            this.value.mappingValue = this.originalMappingValue;
            this.setReturnCode(256);
            this.close();
        }

        private int populateCombo(IWebServiceOperation operation, String path, FieldType type, int count) {
            if (FieldType.BOOLEAN.getTypeName().equals(type.getTypeName()) || FieldType.DATETIME.getTypeName().equals(type.getTypeName()) || FieldType.DECIMAL.getTypeName().equals(type.getTypeName()) || FieldType.NUMBER.getTypeName().equals(type.getTypeName()) || FieldType.STRING.getTypeName().equals(type.getTypeName()) || FieldType.BOOLEAN.getTypeName().equals(type.getTypeName())) {
                this.databaseColumnCombo.add(path);
                if (path.equals(this.value.mappingValue)) {
                    this.databaseColumnCombo.select(count);
                }
            } else {
                IBusinessObject obj = operation.getWebServicePort().getWebService().getWebServiceTypeSet().getBusinessObject("org.eclipse.vtp.framework.synthetic_ws." + operation.getWebServicePort().getWebService().getName().replace(' ', '_') + "." + type.getTypeName());
                if (obj != null) {
                    Iterator i = obj.getFields().iterator();
                    while (i.hasNext()) {
                        IBusinessObjectField field = (IBusinessObjectField)i.next();
                        count = this.populateCombo(operation, String.valueOf(path) + "." + field.getName(), field.getDataType(), count + 1);
                    }
                }
            }
            return count;
        }

        protected void createDialogContents(Composite parent) {
            this.darkBlue = new Color((Device)parent.getDisplay(), 77, 113, 179);
            this.lightBlue = new Color((Device)parent.getDisplay(), 240, 243, 249);
            parent.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ ValueDialog this$1;
                {
                    this.this$1 = valueDialog;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.this$1.darkBlue.dispose();
                    this.this$1.lightBlue.dispose();
                }
            });
            this.setFrameColor(this.darkBlue);
            this.setSideBarColor(this.lightBlue);
            GridLayout gl = new GridLayout(2, false);
            gl.marginTop = 20;
            parent.setLayout((Layout)gl);
            this.noChangeButton = new Button(parent, 16);
            this.noChangeButton.setText("Do not change this field");
            this.noChangeButton.setBackground(parent.getBackground());
            this.noChangeButton.setSelection(this.value.mappingType == -1);
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            this.noChangeButton.setLayoutData((Object)gd);
            this.databaseColumnButton = new Button(parent, 16);
            this.databaseColumnButton.setText("Use the value from this table column");
            this.databaseColumnButton.setBackground(parent.getBackground());
            this.databaseColumnButton.setSelection(this.value.mappingType == 1);
            this.databaseColumnButton.setLayoutData((Object)new GridData());
            this.databaseColumnCombo = new Combo(parent, 2060);
            this.databaseColumnCombo.setLayoutData((Object)new GridData(768));
            this.staticValueButton = new Button(parent, 16);
            this.staticValueButton.setText("Use the value I've entered");
            this.staticValueButton.setBackground(parent.getBackground());
            this.staticValueButton.setSelection(this.value.mappingType == 0);
            this.staticValueButton.setLayoutData((Object)new GridData());
            this.staticValueField = new Text(parent, 2052);
            this.staticValueField.setLayoutData((Object)new GridData(768));
            List services = ((IApplicationProject)WebServiceCallOutputPropertiesPanel.this.callElement.getModel().getApplication().getProject()).getWebServiceSet().getWebServices();
            int i = 0;
            while (i < services.size()) {
                IWebService service = (IWebService)services.get(i);
                if (service.getName().equals(((WebServiceCallOutputPropertiesPanel)WebServiceCallOutputPropertiesPanel.this).settings.sourceWebService)) {
                    List ports = service.getWebServicePorts();
                    int t = 0;
                    while (t < ports.size()) {
                        IWebServicePort port = (IWebServicePort)ports.get(t);
                        if (port.getName().equals(((WebServiceCallOutputPropertiesPanel)WebServiceCallOutputPropertiesPanel.this).settings.sourceWebServicePort)) {
                            List operatiions = port.getWebServiceOperations();
                            int c = 0;
                            while (c < operatiions.size()) {
                                IWebServiceOperation operation = (IWebServiceOperation)operatiions.get(c);
                                if (operation.getName().equals(((WebServiceCallOutputPropertiesPanel)WebServiceCallOutputPropertiesPanel.this).settings.sourceWebServiceOperation)) {
                                    this.populateCombo(operation, "result", operation.getOutput(), 0);
                                }
                                ++c;
                            }
                        }
                        ++t;
                    }
                }
                ++i;
            }
            if (this.value.mappingType == 0) {
                this.staticValueField.setText(this.value.mappingValue == null ? "" : this.value.mappingValue);
            }
            this.databaseColumnCombo.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ValueDialog this$1;
                {
                    this.this$1 = valueDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.updateValue();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.staticValueField.addKeyListener(new KeyListener(this){
                final /* synthetic */ ValueDialog this$1;
                {
                    this.this$1 = valueDialog;
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    this.this$1.updateValue();
                }
            });
            this.noChangeButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ValueDialog this$1;
                {
                    this.this$1 = valueDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (this.this$1.noChangeButton.getSelection()) {
                        this.this$1.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.staticValueButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ValueDialog this$1;
                {
                    this.this$1 = valueDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (this.this$1.staticValueButton.getSelection()) {
                        this.this$1.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.databaseColumnButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ ValueDialog this$1;
                {
                    this.this$1 = valueDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (this.this$1.databaseColumnButton.getSelection()) {
                        this.this$1.updateValue();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }
}

