/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.ISupportedLanguage;
import org.eclipse.vtp.desktop.ui.app.dialogs.GrammarDialog;
import org.eclipse.vtp.desktop.ui.app.dialogs.PromptSequenceDialog;
import org.eclipse.vtp.desktop.ui.app.editors.BrandEditorInput;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaActionListener;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaContentProvider;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaViewer;
import org.eclipse.vtp.framework.media.grammars.CharactersGrammar;
import org.eclipse.vtp.framework.media.grammars.FileGrammar;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.grammars.GrammarVisitorAdapter;
import org.eclipse.vtp.framework.media.grammars.TextGrammar;
import org.eclipse.vtp.framework.media.library.LibraryGrammarEntry;
import org.eclipse.vtp.framework.media.library.LibraryGrammarTranslation;
import org.eclipse.vtp.framework.media.library.LibraryPromptEntry;
import org.eclipse.vtp.framework.media.library.LibraryPromptTranslation;
import org.eclipse.vtp.framework.media.library.LibraryPrompts;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.PromptVisitorAdapter;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.util.BrandLibraryIndex;

public class BrandEditor
extends MultiPageEditorPart {
    private final PromptsContentProvider promptsContent = new PromptsContentProvider();
    private final GrammarsContentProvider grammarsContent = new GrammarsContentProvider();
    private final PromptRenderer promptRenderer = new PromptRenderer();
    private final GrammarRenderer grammarRenderer = new GrammarRenderer();
    private BrandLibraryIndex index;
    private FormToolkit toolkit;
    private ScrolledForm promptForm;
    private ScrolledForm grammarForm;
    private boolean dirty = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        if (!(input instanceof BrandEditorInput)) {
            throw new PartInitException("Wrong type of input");
        }
        this.setInput(input);
        this.setPartName(this.getBrandInput().getName());
        try {
            this.index = this.getBrandInput().load();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PartInitException(e.getMessage());
        }
    }

    private BrandEditorInput getBrandInput() {
        return (BrandEditorInput)this.getEditorInput();
    }

    protected void createPages() {
        this.toolkit = new FormToolkit(this.getContainer().getDisplay());
        this.promptForm = this.toolkit.createScrolledForm(this.getContainer());
        Composite promptPage = this.createPage(this.promptForm, "Prompts");
        Hyperlink addPrompt = this.toolkit.createHyperlink(promptPage, "Add Prompt", 0);
        final MediaViewer promptViewer = new MediaViewer(this.toolkit, promptPage, true);
        promptViewer.getControl().setLayoutData((Object)new GridData(770));
        promptViewer.setContentProvider(this.promptsContent);
        promptViewer.setInput(this.index.getLibrary().getPrompts());
        addPrompt.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Map promptsListsByLocale = new HashMap();
                Iterator i = ((IApplicationProject)BrandEditor.this.getBrandInput().getBrand().getBrandSet().getProject()).getSupportedLanguages().iterator();
                while (i.hasNext()) {
                    ISupportedLanguage lang = (ISupportedLanguage)i.next();
                    promptsListsByLocale.put(lang.getLocale(), new ArrayList());
                }
                PromptSequenceDialog dialog = new PromptSequenceDialog(BrandEditor.this.getSite().getShell(), "", true, promptsListsByLocale, false, false, new IMediaFilesFolder[]{BrandEditor.this.getBrandInput().getBrand().getMediaFilesFolder()}, BrandEditor.this.index.indexAvailablePrompts("", ""), null);
                if (dialog.open() != 0) {
                    return;
                }
                LibraryPromptEntry entry = new LibraryPromptEntry(dialog.getName());
                promptsListsByLocale = dialog.getPromptListsByLocale();
                Iterator i2 = promptsListsByLocale.keySet().iterator();
                while (i2.hasNext()) {
                    Locale locale = (Locale)i2.next();
                    entry.addTranslation(new LibraryPromptTranslation(locale, (List)promptsListsByLocale.get(locale)));
                }
                BrandEditor.this.index.getLibrary().getPrompts().addEntry(entry);
                promptViewer.refresh();
                BrandEditor.this.dirty = true;
                BrandEditor.this.firePropertyChange(257);
            }
        });
        promptViewer.addMediaActionListener(new MediaActionListener(){

            public void processItemAction(Object element, String href) {
            }

            public void processEditAction(Object element) {
                LibraryPromptEntry entry = (LibraryPromptEntry)element;
                Map promptsListsByLocale = new HashMap<Locale, List>();
                Iterator i = ((IApplicationProject)BrandEditor.this.getBrandInput().getBrand().getBrandSet().getProject()).getSupportedLanguages().iterator();
                while (i.hasNext()) {
                    ISupportedLanguage lang = (ISupportedLanguage)i.next();
                    if (entry == null || entry.getTranslation(lang.getLocale()) == null) {
                        promptsListsByLocale.put(lang.getLocale(), new ArrayList());
                        continue;
                    }
                    promptsListsByLocale.put(lang.getLocale(), entry.getTranslation(lang.getLocale()).getAll());
                }
                PromptSequenceDialog dialog = new PromptSequenceDialog(BrandEditor.this.getSite().getShell(), entry.getName(), true, promptsListsByLocale, false, false, new IMediaFilesFolder[]{BrandEditor.this.getBrandInput().getBrand().getMediaFilesFolder()}, BrandEditor.this.index.indexAvailablePrompts(entry.getName(), ""), null);
                if (dialog.open() != 0) {
                    return;
                }
                BrandEditor.this.index.getLibrary().getPrompts().removeEntry(entry);
                entry = new LibraryPromptEntry(dialog.getName());
                promptsListsByLocale = dialog.getPromptListsByLocale();
                Iterator i2 = promptsListsByLocale.keySet().iterator();
                while (i2.hasNext()) {
                    Locale locale = (Locale)i2.next();
                    entry.addTranslation(new LibraryPromptTranslation(locale, (List)promptsListsByLocale.get(locale)));
                }
                BrandEditor.this.index.getLibrary().getPrompts().addEntry(entry);
                promptViewer.refresh();
                BrandEditor.this.dirty = true;
                BrandEditor.this.firePropertyChange(257);
            }

            public void processDeleteAction(Object element) {
                LibraryPromptEntry entry = (LibraryPromptEntry)element;
                if (MessageDialog.openConfirm((Shell)BrandEditor.this.getSite().getShell(), (String)"Delete Prompt", (String)("Are you sure you want to remove the prompt '" + entry.getName() + "'?"))) {
                    BrandEditor.this.index.getLibrary().getPrompts().removeEntry(entry);
                }
                promptViewer.refresh();
                BrandEditor.this.dirty = true;
                BrandEditor.this.firePropertyChange(257);
            }
        });
        this.setPageText(this.addPage((Control)this.promptForm), "Prompts");
        this.grammarForm = this.toolkit.createScrolledForm(this.getContainer());
        Composite grammarPage = this.createPage(this.grammarForm, "Grammars");
        Hyperlink addGrammar = this.toolkit.createHyperlink(grammarPage, "Add Grammar", 0);
        final MediaViewer grammarViewer = new MediaViewer(this.toolkit, grammarPage, true);
        grammarViewer.getControl().setLayoutData((Object)new GridData(770));
        grammarViewer.setContentProvider(this.grammarsContent);
        grammarViewer.setInput(this.index.getLibrary().getGrammars());
        addGrammar.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Map grammarListsByLocale = new HashMap();
                Iterator i = ((IApplicationProject)BrandEditor.this.getBrandInput().getBrand().getBrandSet().getProject()).getSupportedLanguages().iterator();
                while (i.hasNext()) {
                    ISupportedLanguage lang = (ISupportedLanguage)i.next();
                    grammarListsByLocale.put(lang.getLocale(), new ArrayList());
                }
                GrammarDialog dialog = new GrammarDialog(BrandEditor.this.getSite().getShell(), "", true, grammarListsByLocale, false, new IMediaFilesFolder[]{BrandEditor.this.getBrandInput().getBrand().getMediaFilesFolder()}, BrandEditor.this.index.indexAvailableGrammars("", ""));
                if (dialog.open() != 0) {
                    return;
                }
                LibraryGrammarEntry entry = new LibraryGrammarEntry(dialog.getName());
                grammarListsByLocale = dialog.getGrammarListsByLocale();
                Iterator i2 = grammarListsByLocale.keySet().iterator();
                while (i2.hasNext()) {
                    Locale locale = (Locale)i2.next();
                    entry.addTranslation(new LibraryGrammarTranslation(locale, (List)grammarListsByLocale.get(locale)));
                }
                BrandEditor.this.index.getLibrary().getGrammars().addEntry(entry);
                promptViewer.refresh();
                BrandEditor.this.dirty = true;
                BrandEditor.this.firePropertyChange(257);
            }
        });
        grammarViewer.addMediaActionListener(new MediaActionListener(){

            public void processItemAction(Object element, String href) {
            }

            public void processEditAction(Object element) {
                LibraryGrammarEntry entry = (LibraryGrammarEntry)element;
                Map grammarListsByLocale = new HashMap<Locale, List>();
                Iterator i = ((IApplicationProject)BrandEditor.this.getBrandInput().getBrand().getBrandSet().getProject()).getSupportedLanguages().iterator();
                while (i.hasNext()) {
                    ISupportedLanguage lang = (ISupportedLanguage)i.next();
                    if (entry == null || entry.getTranslation(lang.getLocale()) == null) {
                        grammarListsByLocale.put(lang.getLocale(), new ArrayList());
                        continue;
                    }
                    grammarListsByLocale.put(lang.getLocale(), entry.getTranslation(lang.getLocale()).getAll());
                }
                GrammarDialog dialog = new GrammarDialog(BrandEditor.this.getSite().getShell(), entry.getName(), true, grammarListsByLocale, false, new IMediaFilesFolder[]{BrandEditor.this.getBrandInput().getBrand().getMediaFilesFolder()}, BrandEditor.this.index.indexAvailableGrammars(entry.getName(), ""));
                if (dialog.open() != 0) {
                    return;
                }
                BrandEditor.this.index.getLibrary().getGrammars().removeEntry(entry);
                entry = new LibraryGrammarEntry(dialog.getName());
                grammarListsByLocale = dialog.getGrammarListsByLocale();
                Iterator i2 = grammarListsByLocale.keySet().iterator();
                while (i2.hasNext()) {
                    Locale locale = (Locale)i2.next();
                    entry.addTranslation(new LibraryGrammarTranslation(locale, (List)grammarListsByLocale.get(locale)));
                }
                BrandEditor.this.index.getLibrary().getGrammars().addEntry(entry);
                grammarViewer.refresh();
                BrandEditor.this.dirty = true;
                BrandEditor.this.firePropertyChange(257);
            }

            public void processDeleteAction(Object element) {
                LibraryGrammarEntry entry = (LibraryGrammarEntry)element;
                if (MessageDialog.openConfirm((Shell)BrandEditor.this.getSite().getShell(), (String)"Delete Grammar", (String)("Are you sure you want to remove the grammar '" + entry.getName() + "'?"))) {
                    BrandEditor.this.index.getLibrary().getGrammars().removeEntry(entry);
                }
                grammarViewer.refresh();
                BrandEditor.this.dirty = true;
                BrandEditor.this.firePropertyChange(257);
            }
        });
        this.setPageText(this.addPage((Control)this.grammarForm), "Grammars");
    }

    private Composite createPage(ScrolledForm form, String name) {
        form.setText(String.valueOf(this.getPartName()) + " " + name);
        Composite page = form.getBody();
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        page.setLayout((Layout)layout);
        return page;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.getBrandInput().save(this.index, monitor);
            this.dirty = false;
            this.firePropertyChange(257);
        }
        catch (IOException e) {
            this.showMessage("Save Failed", e.getMessage());
        }
    }

    public void doSaveAs() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        try {
            this.toolkit.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.dispose();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.dispose();
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
    }

    private class GrammarRenderer
    extends GrammarVisitorAdapter {
        private GrammarRenderer() {
        }

        public Object charactersGrammar(CharactersGrammar arg0) {
            return arg0.getCharacters();
        }

        public Object fileGrammar(FileGrammar arg0) {
            return "<" + arg0.getPath() + ">";
        }

        public Object textGrammar(TextGrammar arg0) {
            return arg0.getContent();
        }
    }

    private class GrammarsContentProvider
    implements MediaContentProvider {
        private GrammarsContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof LibraryPrompts) {
                Collection names = BrandEditor.this.index.getGrammarEntryNames();
                ArrayList<LibraryGrammarEntry> entries = new ArrayList<LibraryGrammarEntry>(names.size());
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    entries.add(BrandEditor.this.index.getGrammarEntry((String)i.next()));
                }
                return entries.toArray();
            }
            return new Object[0];
        }

        public boolean isElementInherited(Object element) {
            return !BrandEditor.this.index.getLibrary().getGrammars().getEntries().contains(element);
        }

        public String getElementLabel(Object element) {
            if (element instanceof LibraryGrammarEntry) {
                return ((LibraryGrammarEntry)element).getName();
            }
            return null;
        }

        public Object[] getItems(Object element) {
            if (element instanceof LibraryGrammarEntry) {
                LibraryGrammarEntry entry = (LibraryGrammarEntry)element;
                Locale locale = BrandEditor.this.index.getDefaultLocale();
                if (entry.getTranslation(locale) == null || entry.getTranslation(locale).size() == 0) {
                    locale = new Locale(locale.getLanguage(), locale.getCountry());
                }
                if (entry.getTranslation(locale) == null || entry.getTranslation(locale).size() == 0) {
                    locale = new Locale(locale.getLanguage());
                }
                if (entry.getTranslation(locale) != null) {
                    return entry.getTranslation(locale).getAll().toArray();
                }
            }
            return new Object[0];
        }

        public String getItemText(Object item) {
            if (item instanceof Grammar) {
                StringBuffer buf = new StringBuffer();
                List all = BrandEditor.this.index.solveGrammar((Grammar)item);
                Iterator i = all.iterator();
                while (i.hasNext()) {
                    buf.append(((Grammar)i.next()).accept((Grammar.Visitor)BrandEditor.this.grammarRenderer));
                    if (!i.hasNext()) continue;
                    buf.append(' ');
                }
                return buf.toString();
            }
            return null;
        }

        public String getItemColor(Object item) {
            return null;
        }

        public String getItemHREF(Object item) {
            return null;
        }

        public void inputChanged(Object oldInput, Object newInput) {
        }
    }

    private class PromptRenderer
    extends PromptVisitorAdapter {
        private PromptRenderer() {
        }

        public Object charactersPrompt(CharactersPrompt arg0) {
            return arg0.getCharacters().toUpperCase();
        }

        public Object filePrompt(FilePrompt arg0) {
            String txt = BrandEditor.this.index.getAlternateText(arg0.getPath());
            if (txt == null || txt.length() == 0) {
                txt = arg0.getPath();
            }
            return txt;
        }

        public Object textPrompt(TextPrompt arg0) {
            return arg0.getContent();
        }
    }

    private class PromptsContentProvider
    implements MediaContentProvider {
        private PromptsContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof LibraryPrompts) {
                Collection names = BrandEditor.this.index.getPromptEntryNames();
                ArrayList<LibraryPromptEntry> entries = new ArrayList<LibraryPromptEntry>(names.size());
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    entries.add(BrandEditor.this.index.getPromptEntry((String)i.next()));
                }
                return entries.toArray();
            }
            return new Object[0];
        }

        public boolean isElementInherited(Object element) {
            return !BrandEditor.this.index.getLibrary().getPrompts().getEntries().contains(element);
        }

        public String getElementLabel(Object element) {
            if (element instanceof LibraryPromptEntry) {
                return ((LibraryPromptEntry)element).getName();
            }
            return null;
        }

        public Object[] getItems(Object element) {
            if (element instanceof LibraryPromptEntry) {
                LibraryPromptEntry entry = (LibraryPromptEntry)element;
                Locale locale = BrandEditor.this.index.getDefaultLocale();
                if (entry.getTranslation(locale) == null || entry.getTranslation(locale).size() == 0) {
                    locale = new Locale(locale.getLanguage(), locale.getCountry());
                }
                if (entry.getTranslation(locale) == null || entry.getTranslation(locale).size() == 0) {
                    locale = new Locale(locale.getLanguage());
                }
                if (entry.getTranslation(locale) != null) {
                    return entry.getTranslation(locale).getAll().toArray();
                }
            }
            return new Object[0];
        }

        public String getItemText(Object item) {
            if (item instanceof Prompt) {
                StringBuffer buf = new StringBuffer();
                List all = BrandEditor.this.index.solvePrompt((Prompt)item);
                Iterator i = all.iterator();
                while (i.hasNext()) {
                    buf.append(((Prompt)i.next()).accept((Prompt.Visitor)BrandEditor.this.promptRenderer));
                    if (!i.hasNext()) continue;
                    buf.append(' ');
                }
                return buf.toString();
            }
            return null;
        }

        public String getItemColor(Object item) {
            return null;
        }

        public String getItemHREF(Object item) {
            return null;
        }

        public void inputChanged(Object oldInput, Object newInput) {
        }
    }
}

