/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.ui.app.dialogs.PromptSequenceDialog;
import org.eclipse.vtp.desktop.ui.app.editors.PersonaEditorInput;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaActionListener;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaContentProvider;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaViewer;
import org.eclipse.vtp.framework.media.persona.PersonaPromptEntry;
import org.eclipse.vtp.framework.media.persona.PersonaPromptGroup;
import org.eclipse.vtp.framework.media.persona.PersonaPrompts;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.PromptVisitorAdapter;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.util.PersonaIndex;

public class PersonaEditor
extends MultiPageEditorPart {
    private final PromptsContentProvider promptsContent = new PromptsContentProvider();
    private final PromptRenderer promptRenderer = new PromptRenderer();
    private PersonaIndex index;
    private PersonaPrompts prompts;
    private FormToolkit toolkit;
    private ScrolledForm promptForm;
    private boolean dirty = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        if (!(input instanceof PersonaEditorInput)) {
            throw new PartInitException("Wrong type of input");
        }
        this.setInput(input);
        this.setPartName(this.getPersonaInput().getName());
        try {
            this.index = this.getPersonaInput().load();
        }
        catch (IOException e) {
            throw new PartInitException(e.getMessage());
        }
        this.prompts = new PersonaPrompts();
    }

    private PersonaEditorInput getPersonaInput() {
        return (PersonaEditorInput)this.getEditorInput();
    }

    protected void createPages() {
        this.toolkit = new FormToolkit(this.getContainer().getDisplay());
        this.toolkit.getColors().createColor("red", 255, 0, 0);
        this.toolkit.getColors().createColor("green", 0, 255, 0);
        this.toolkit.getColors().createColor("blue", 0, 0, 255);
        this.promptForm = this.toolkit.createScrolledForm(this.getContainer());
        Composite promptPage = this.createPage(this.promptForm, "Prompts");
        Iterator i = this.index.getPromptGroupNames().iterator();
        while (i.hasNext()) {
            final String groupName = (String)i.next();
            Section section = this.toolkit.createSection(promptPage, 266);
            section.setLayoutData((Object)new GridData(770));
            section.setText(groupName);
            PersonaPromptGroup group = new PersonaPromptGroup(groupName);
            this.prompts.addGroup(group);
            if (this.index.getPersona().getPrompts().getGroup(groupName) == null) {
                this.index.getPersona().getPrompts().addGroup(new PersonaPromptGroup(groupName));
            }
            Iterator j = this.index.getPromptEntryNames(groupName).iterator();
            while (j.hasNext()) {
                String entryName = (String)j.next();
                PersonaPromptEntry entry = this.index.getPersona().getPrompts().getGroup(groupName).getEntry(entryName);
                if (entry == null) {
                    entry = new PersonaPromptEntry(entryName, new Prompt[]{new TextPrompt(this.index.getPromptEntryDefault(groupName, entryName))});
                }
                group.addEntry(entry);
            }
            final MediaViewer viewer = new MediaViewer(this.toolkit, (Composite)section, false);
            viewer.addMediaActionListener(new MediaActionListener(){

                public void processItemAction(Object element, String href) {
                }

                public void processEditAction(Object element) {
                    HashMap<Locale, List> map = new HashMap<Locale, List>(1);
                    PersonaPromptEntry entry = (PersonaPromptEntry)element;
                    Locale locale = new Locale(PersonaEditor.this.index.getLocale().getLanguage());
                    map.put(locale, entry.getAll());
                    PromptSequenceDialog dialog = new PromptSequenceDialog(PersonaEditor.this.getSite().getShell(), entry.getName(), false, map, true, false, new IMediaFilesFolder[]{PersonaEditor.this.getPersonaInput().getProject().getMediaFilesFolder()}, PersonaEditor.this.index.indexAvailablePrompts(groupName, entry.getName()), null);
                    if (dialog.open() != 0) {
                        return;
                    }
                    List results = (List)dialog.getPromptListsByLocale().get(locale);
                    entry.setAll(results);
                    if (results.isEmpty()) {
                        entry.add((Prompt)new TextPrompt(PersonaEditor.this.index.getPromptEntryDefault(groupName, entry.getName())));
                        PersonaEditor.this.index.getPersona().getPrompts().getGroup(groupName).removeEntry(entry);
                    } else if (PersonaEditor.this.index.getPersona().getPrompts().getGroup(groupName).getEntry(entry.getName()) == null) {
                        PersonaEditor.this.index.getPersona().getPrompts().getGroup(groupName).addEntry(entry);
                    }
                    viewer.refresh();
                    PersonaEditor.this.dirty = true;
                    PersonaEditor.this.firePropertyChange(257);
                }

                public void processDeleteAction(Object element) {
                }
            });
            viewer.setContentProvider(this.promptsContent);
            viewer.setInput(group);
            section.setClient(viewer.getControl());
        }
        this.setPageText(this.addPage((Control)this.promptForm), "Prompts");
    }

    private Composite createPage(ScrolledForm form, String name) {
        form.setText(String.valueOf(this.getPartName()) + " " + name + " (" + this.index.getLocale().getDisplayName() + ")");
        Composite page = form.getBody();
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        page.setLayout((Layout)layout);
        return page;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.getPersonaInput().save(this.index, monitor);
            this.dirty = false;
            this.firePropertyChange(257);
        }
        catch (IOException e) {
            this.showMessage("Save Failed", e.getMessage());
        }
    }

    public void doSaveAs() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        try {
            this.toolkit.dispose();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.dispose();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.dispose();
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.getEditorSite().getShell(), (String)title, (String)message);
    }

    private class PromptRenderer
    extends PromptVisitorAdapter {
        private PromptRenderer() {
        }

        public Object charactersPrompt(CharactersPrompt arg0) {
            return arg0.getCharacters().toUpperCase();
        }

        public Object filePrompt(FilePrompt arg0) {
            String txt = PersonaEditor.this.index.getAlternateText(arg0.getPath());
            if (txt.length() == 0) {
                txt = arg0.getPath();
            }
            return txt;
        }

        public Object textPrompt(TextPrompt arg0) {
            return arg0.getContent();
        }
    }

    private class PromptsContentProvider
    implements MediaContentProvider {
        private PromptsContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof PersonaPromptGroup) {
                return ((PersonaPromptGroup)input).getEntries().toArray();
            }
            return new Object[0];
        }

        public String getElementLabel(Object element) {
            if (element instanceof PersonaPromptEntry) {
                return ((PersonaPromptEntry)element).getName();
            }
            return null;
        }

        public Object[] getItems(Object element) {
            if (element instanceof PersonaPromptEntry) {
                return ((PersonaPromptEntry)element).getAll().toArray();
            }
            return new Object[0];
        }

        public String getItemText(Object item) {
            if (item instanceof Prompt) {
                StringBuffer buf = new StringBuffer();
                List all = PersonaEditor.this.index.solvePrompt((Prompt)item);
                Iterator i = all.iterator();
                while (i.hasNext()) {
                    buf.append(((Prompt)i.next()).accept((Prompt.Visitor)PersonaEditor.this.promptRenderer));
                    if (!i.hasNext()) continue;
                    buf.append(' ');
                }
                return buf.toString();
            }
            return null;
        }

        public String getItemColor(Object item) {
            return null;
        }

        public String getItemHREF(Object item) {
            return null;
        }

        public boolean isElementInherited(Object element) {
            return false;
        }

        public void inputChanged(Object oldInput, Object newInput) {
        }
    }
}

