/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.editors;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.localdata.ILocalLanguagePack;
import org.eclipse.vtp.desktop.core.project.IAudioFile;
import org.eclipse.vtp.desktop.core.project.IMediaFile;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.framework.media.language.MediaLanguage;
import org.eclipse.vtp.framework.media.util.PersonaIndex;
import org.eclipse.vtp.framework.media.xml.MediaXML;

public class UIPersonaIndex
extends PersonaIndex {
    private static final MediaLanguage ENGLISH;
    private static final MediaLanguage SPANISH;
    private final IMediaFilesFolder files;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        MediaLanguage en = null;
        MediaLanguage es = null;
        try {
            Enumeration e = Collections.enumeration(DesktopCorePlugin.getDefault().getLocalDomain().getVendorByName("").getLanguagePacks());
            while (e.hasMoreElements()) {
                Object var5_6;
                InputStream input = ((ILocalLanguagePack)e.nextElement()).openScript();
                try {
                    MediaLanguage tmp = MediaXML.loadLanguage((Source)new StreamSource(input));
                    if (new Locale("en").equals(tmp.getLocale())) {
                        en = tmp;
                    } else if (new Locale("es").equals(tmp.getLocale())) {
                        es = tmp;
                    }
                    var5_6 = null;
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    try {
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                if (input == null) continue;
                input.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ENGLISH = en;
        SPANISH = es;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UIPersonaIndex(IPersonaProject project) throws IOException, CoreException {
        String code = project.getLanguageCode();
        if (code.indexOf(45) < 0) {
            this.setLocale(new Locale(code));
        } else {
            this.setLocale(new Locale(code.substring(0, code.indexOf(45))));
        }
        InputStream input = null;
        try {
            input = project.getPromptSet().read();
            this.setPersona(MediaXML.loadPersona((Source)new StreamSource(input)));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (input != null) {
            input.close();
        }
        this.files = project.getMediaFilesFolder();
        this.setLanguage(project.getLanguageCode().startsWith("es") ? SPANISH : ENGLISH);
    }

    public boolean hasAudioFile(String path) {
        IMediaFilesFolder container = this.files;
        IMediaFile file = null;
        StringTokenizer st = new StringTokenizer(path, "/\\");
        while (st.hasMoreElements()) {
            String nextToken = st.nextToken();
            if (st.hasMoreTokens()) {
                container = container.getMediaFolder(nextToken);
                continue;
            }
            file = container.getMediaFile(nextToken);
        }
        return file instanceof IAudioFile;
    }

    public String getAlternateText(String path) {
        IMediaFilesFolder container = this.files;
        IMediaFile file = null;
        StringTokenizer st = new StringTokenizer(path, "/\\");
        while (st.hasMoreElements()) {
            String nextToken = st.nextToken();
            if (st.hasMoreTokens()) {
                container = container.getMediaFolder(nextToken);
                continue;
            }
            file = container.getMediaFile(nextToken);
        }
        if (file instanceof IAudioFile) {
            return ((IAudioFile)file).getAlternateText();
        }
        return "";
    }
}

