/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.properties;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.vtp.desktop.core.project.IApplicationProject;
import org.eclipse.vtp.desktop.core.project.IAudioFile;
import org.eclipse.vtp.desktop.core.project.IBrand;
import org.eclipse.vtp.desktop.core.project.IMediaResource;
import org.eclipse.vtp.desktop.core.project.IPersonaProject;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;

public class AudioFilePropertyPage
extends PropertyPage {
    private static final String PATH_TITLE = "Path:";
    private Text ownerText;

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        IAudioFile audioFile = (IAudioFile)this.getElement();
        String path = audioFile.getMediaPath();
        IVoiceResource r = audioFile.getParent();
        while (r.getParent() != null) {
            r = r.getParent();
        }
        String personaBrandLabelText = "";
        String personaBrandFieldText = "";
        if (r instanceof IApplicationProject) {
            personaBrandLabelText = "Brand:";
            r = audioFile.getParent();
            while (r instanceof IMediaResource) {
                r = r.getParent();
            }
            personaBrandFieldText = ((IBrand)r.getParent()).getName();
        } else {
            personaBrandLabelText = "Persona:";
            try {
                personaBrandFieldText = ((IPersonaProject)r).getPersonaName();
            }
            catch (CoreException e) {
                e.printStackTrace();
                personaBrandFieldText = "Unknown";
            }
        }
        Label personaBrandLabel = new Label(composite, 0);
        personaBrandLabel.setText(personaBrandLabelText);
        Text personaBrandField = new Text(composite, 72);
        personaBrandField.setText(personaBrandFieldText);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(PATH_TITLE);
        Text pathValueText = new Text(composite, 72);
        pathValueText.setText(path);
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        IAudioFile audioFile = (IAudioFile)this.getElement();
        Label ownerLabel = new Label(composite, 0);
        ownerLabel.setText("Alternate Text");
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 2;
        ownerLabel.setLayoutData((Object)gd2);
        this.ownerText = new Text(composite, 2114);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.ownerText.setLayoutData((Object)gd);
        try {
            String owner = audioFile.getAlternateText();
            this.ownerText.setText(owner != null ? owner : "");
        }
        catch (Exception exception) {
            this.ownerText.setText("");
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        return composite;
    }

    protected void performDefaults() {
        try {
            IAudioFile audioFile = (IAudioFile)this.getElement();
            String owner = audioFile.getAlternateText();
            this.ownerText.setText(owner != null ? owner : "");
        }
        catch (Exception exception) {
            this.ownerText.setText("");
        }
    }

    public boolean performOk() {
        IAudioFile audioFile = (IAudioFile)this.getElement();
        audioFile.setAlternateText(this.ownerText.getText() == null ? "" : this.ownerText.getText());
        return true;
    }
}

