/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.ui.app.viewers;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaContentProvider;
import org.eclipse.vtp.desktop.ui.app.viewers.MediaViewer;

public class MediaViewerRow
extends HyperlinkAdapter {
    private static final String HREF_ITEM = "urn:openVXML:MediaViewerRow:item:";
    private static final String HREF_EDIT = "urn:openVXML:MediaViewerRow:edit";
    private static final String HREF_DELETE = "urn:openVXML:MediaViewerRow:delete";
    private MediaViewer viewer;
    private Composite labelContainer = null;
    private Label label = null;
    private Composite valueContainer = null;
    private FormText value = null;
    private Composite editContainer = null;
    private ImageHyperlink editLink = null;
    private Composite deleteContainer = null;
    private ImageHyperlink deleteLink = null;
    private Object element = null;

    public MediaViewerRow(MediaViewer viewer) {
        this.viewer = viewer;
        FormToolkit toolkit = viewer.getToolkit();
        Composite composite = viewer.getComposite();
        this.labelContainer = toolkit.createComposite(composite);
        this.labelContainer.setLayout((Layout)new GridLayout(1, false));
        this.labelContainer.setLayoutData((Object)new GridData(272));
        this.label = toolkit.createLabel(this.labelContainer, "");
        this.label.setText("");
        this.valueContainer = toolkit.createComposite(composite);
        TableWrapLayout valueLayout = new TableWrapLayout();
        valueLayout.rightMargin = 5;
        valueLayout.leftMargin = 5;
        valueLayout.bottomMargin = 5;
        valueLayout.topMargin = 5;
        this.valueContainer.setLayout((Layout)valueLayout);
        this.valueContainer.setLayoutData((Object)new GridData(784));
        this.value = toolkit.createFormText(this.valueContainer, false);
        this.value.setLayoutData((Object)this.createTableWrapData());
        this.value.setColor("red", toolkit.getColors().getColor("red"));
        this.value.setColor("green", toolkit.getColors().getColor("green"));
        this.value.setColor("blue", toolkit.getColors().getColor("blue"));
        this.editContainer = toolkit.createComposite(composite);
        this.editContainer.setLayout((Layout)new GridLayout(1, false));
        this.editContainer.setLayoutData((Object)new GridData(272));
        this.editLink = toolkit.createImageHyperlink(this.editContainer, 0);
        this.editLink.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        this.editLink.setHref((Object)HREF_EDIT);
        this.editLink.setEnabled(false);
        this.editLink.addHyperlinkListener((IHyperlinkListener)this);
        if (viewer.showDelete()) {
            this.deleteContainer = toolkit.createComposite(composite);
            this.deleteContainer.setLayout((Layout)new GridLayout(1, false));
            this.deleteContainer.setLayoutData((Object)new GridData(272));
            this.deleteLink = toolkit.createImageHyperlink(this.deleteContainer, 0);
            this.deleteLink.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
            this.deleteLink.setHref((Object)HREF_DELETE);
            this.deleteLink.setEnabled(false);
            this.deleteLink.addHyperlinkListener((IHyperlinkListener)this);
        }
    }

    private TableWrapData createTableWrapData() {
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.valign = 128;
        td.grabHorizontal = true;
        return td;
    }

    public void setForeground(Color color) {
        this.labelContainer.setForeground(color);
        this.label.setForeground(color);
        this.valueContainer.setForeground(color);
        this.value.setForeground(color);
        this.editContainer.setForeground(color);
        this.editLink.setForeground(color);
        if (this.viewer.showDelete()) {
            this.deleteContainer.setForeground(color);
            this.deleteLink.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        this.labelContainer.setBackground(color);
        this.label.setBackground(color);
        this.valueContainer.setBackground(color);
        this.value.setBackground(color);
        this.editContainer.setBackground(color);
        this.editLink.setBackground(color);
        if (this.viewer.showDelete()) {
            this.deleteContainer.setBackground(color);
            this.deleteLink.setBackground(color);
        }
    }

    public void setVisible(boolean visible) {
        this.label.setVisible(visible);
        this.value.setVisible(visible);
        this.editLink.setVisible(visible);
        if (this.viewer.showDelete()) {
            this.deleteLink.setVisible(visible);
        }
    }

    public void setElement(Object element) {
        this.element = element;
        if (element == null) {
            this.label.setText("");
            this.value.setText("<form></form>", true, false);
            this.editLink.setEnabled(false);
            if (this.viewer.showDelete()) {
                this.deleteLink.setEnabled(false);
            }
        } else {
            MediaContentProvider provider = this.viewer.getContentProvider();
            String labelText = provider.getElementLabel(element);
            this.label.setText(labelText == null ? "" : labelText);
            Object[] items = provider.getItems(element);
            StringBuffer valueText = new StringBuffer("<form><p vspace=\"false\">");
            int i = 0;
            while (i < items.length) {
                if (i > 0) {
                    valueText.append(' ');
                }
                String text = provider.getItemText(items[i]);
                String color = provider.getItemColor(items[i]);
                String href = provider.getItemHREF(items[i]);
                if (href != null) {
                    valueText.append("<a href=\"").append(HREF_ITEM).append(href).append("\">");
                } else if (color != null) {
                    valueText.append("<span color=\"").append(color).append("\">");
                }
                if (text != null) {
                    valueText.append(text);
                }
                if (href != null) {
                    valueText.append("</a>");
                } else if (color != null) {
                    valueText.append("</span>");
                }
                ++i;
            }
            String xml = valueText.append("</p></form>").toString();
            this.value.setText(xml, true, false);
            this.editLink.setEnabled(true);
            if (this.viewer.showDelete()) {
                this.deleteLink.setEnabled(true);
            }
        }
    }

    public void linkActivated(HyperlinkEvent e) {
        if (this.element == null) {
            return;
        }
        if (HREF_EDIT.equals(e.getHref().toString())) {
            this.viewer.editClicked(this.element);
        } else if (HREF_DELETE.equals(e.getHref().toString())) {
            this.viewer.deleteClicked(this.element);
        } else {
            this.viewer.itemClicked(this.element, e.getHref().toString().substring(HREF_ITEM.length()));
        }
    }
}

