/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.internal.core.UpdateCore;

public class SiteFeatureReference
extends SiteFeatureReferenceModel
implements ISiteFeatureReference {
    private List categories;

    public SiteFeatureReference() {
    }

    public SiteFeatureReference(ISiteFeatureReference ref) {
        super(ref);
    }

    public ICategory[] getCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList();
            String[] categoriesAsString = this.getCategoryNames();
            int i = 0;
            while (i < categoriesAsString.length) {
                ICategory siteCat = this.getSite().getCategory(categoriesAsString[i]);
                if (siteCat != null) {
                    this.categories.add(siteCat);
                } else {
                    String siteURL = this.getSite().getURL() != null ? this.getSite().getURL().toExternalForm() : null;
                    UpdateCore.warn("Category " + categoriesAsString[i] + " not found in Site:" + siteURL);
                }
                ++i;
            }
        }
        ICategory[] result = new ICategory[]{};
        if (this.categories != null && !this.categories.isEmpty()) {
            result = new ICategory[this.categories.size()];
            this.categories.toArray(result);
        }
        return result;
    }

    public void addCategory(ICategory category) {
        this.addCategoryName(category.getName());
    }
}

