/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.TextEditChangePreviewViewer;
import org.eclipse.ltk.internal.ui.refactoring.TextEditGroupNode;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;

public abstract class InternalLanguageElementNode
extends TextEditChangeNode.ChildNode {
    private List fChildren;
    private GroupCategorySet fGroupCategories;

    protected InternalLanguageElementNode(PreviewNode parent) {
        super(parent);
    }

    ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        TextEditChangeNode element = this.getTextEditChangeNode();
        if (element == null) {
            return null;
        }
        return element.getChangePreviewViewerDescriptor();
    }

    void feedInput(IChangePreviewViewer viewer, List categories) throws CoreException {
        TextEditChangeNode element = this.getTextEditChangeNode();
        if (element != null) {
            Change change = element.getChange();
            if (change instanceof TextEditBasedChange) {
                List groups = this.collectTextEditBasedChangeGroups(categories);
                viewer.setInput(TextEditChangePreviewViewer.createInput(change, groups.toArray(new TextEditBasedChangeGroup[groups.size()]), this.getTextRange()));
            }
        } else {
            viewer.setInput(null);
        }
    }

    void setEnabled(boolean enabled) {
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            PreviewNode element = (PreviewNode)iter.next();
            element.setEnabled(enabled);
        }
    }

    void setEnabledShallow(boolean enabled) {
    }

    int getActive() {
        Assert.isTrue((this.fChildren.size() > 0 ? 1 : 0) != 0);
        int result = ((PreviewNode)this.fChildren.get(0)).getActive();
        int i = 1;
        while (i < this.fChildren.size()) {
            PreviewNode element = (PreviewNode)this.fChildren.get(i);
            result = PreviewNode.ACTIVATION_TABLE[element.getActive()][result];
            if (result == 1) break;
            ++i;
        }
        return result;
    }

    PreviewNode[] getChildren() {
        if (this.fChildren == null) {
            return PreviewNode.EMPTY_CHILDREN;
        }
        return this.fChildren.toArray(new PreviewNode[this.fChildren.size()]);
    }

    boolean hasOneGroupCategory(List categories) {
        if (this.fChildren == null) {
            return false;
        }
        return this.getGroupCategorySet().containsOneCategory(categories);
    }

    private GroupCategorySet getGroupCategorySet() {
        if (this.fGroupCategories == null) {
            this.fGroupCategories = GroupCategorySet.NONE;
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                PreviewNode node = (PreviewNode)iter.next();
                GroupCategorySet other = null;
                if (node instanceof TextEditGroupNode) {
                    other = ((TextEditGroupNode)node).getGroupCategorySet();
                } else if (node instanceof InternalLanguageElementNode) {
                    other = ((InternalLanguageElementNode)node).getGroupCategorySet();
                } else {
                    Assert.isTrue((boolean)false, (String)"Shouldn't happen");
                }
                this.fGroupCategories = GroupCategorySet.union((GroupCategorySet)this.fGroupCategories, (GroupCategorySet)other);
            }
        }
        return this.fGroupCategories;
    }

    protected void internalAddChild(TextEditChangeNode.ChildNode child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(2);
        }
        this.fChildren.add(child);
    }

    private List collectTextEditBasedChangeGroups(List categories) {
        ArrayList<TextEditBasedChangeGroup> result = new ArrayList<TextEditBasedChangeGroup>(10);
        PreviewNode[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            PreviewNode child = children[i];
            if (child instanceof TextEditGroupNode) {
                TextEditBasedChangeGroup changeGroup = ((TextEditGroupNode)child).getChangeGroup();
                if (categories == null || changeGroup.getGroupCategorySet().containsOneCategory(categories)) {
                    result.add(changeGroup);
                }
            } else if (child instanceof InternalLanguageElementNode) {
                result.addAll(((InternalLanguageElementNode)child).collectTextEditBasedChangeGroups(categories));
            }
            ++i;
        }
        return result;
    }

    public abstract IRegion getTextRange() throws CoreException;
}

