/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.infoserv.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.eclipse.vtp.framework.infoserv.spi.InformationChannel;
import org.eclipse.vtp.framework.infoserv.spi.RuleSet;
import org.eclipse.vtp.framework.infoserv.spi.RulesetChangeListener;

public abstract class AbstractInformationChannel
implements InformationChannel {
    private List listeners = new ArrayList();
    private RuleSet rs = new RuleSet();

    public static String encodeInformationEvent(String[] categories, String message, Properties properties, Date timestamp) {
        StringBuffer categoryBuffer = new StringBuffer();
        int i = 0;
        while (i < categories.length) {
            categoryBuffer.append('[');
            categoryBuffer.append(categories[i]);
            categoryBuffer.append("] ");
            ++i;
        }
        StringBuffer propertiesBuffer = new StringBuffer();
        Enumeration<Object> enu = properties.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties.getProperty(key);
            propertiesBuffer.append("\r\n\t");
            propertiesBuffer.append(key);
            propertiesBuffer.append(" :  ");
            propertiesBuffer.append(value);
        }
        String string = String.valueOf(timestamp.toString()) + " " + categoryBuffer.toString() + message + propertiesBuffer.toString();
        return string;
    }

    public RuleSet getRuleSet() {
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRuleSet(RuleSet rs) {
        this.rs = rs;
        RulesetChangeListener[] allListeners = null;
        List list = this.listeners;
        synchronized (list) {
            allListeners = this.listeners.toArray(new RulesetChangeListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < allListeners.length) {
            allListeners[i].rulesetChanged((InformationChannel)this);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRulesetChangeListener(RulesetChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRulesetChangeListener(RulesetChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

