/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.explorer.virtual;

import java.util.Collection;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * @author ljulien
 */
public interface IVirtualNode
{
	/**
	 * Name of the Virtual Node
	 * @return
	 */
	public String getName ();
	
	/**
	 * Display Name of the Virtual Node - Will be displayed in the Model Explorer
	 * if null, getName will be used
	 * @return
	 */
	public String getDisplayName ();
	
	/**
	 * @return the parent of this node in the tree
	 */
	public Object getParent ();
	
	/**
	 * @return true if has any children?
	 */
	public boolean hasChildren ();
	
	/**
	 * @return The child array
	 */
	public Object [] getChildrenArray ();
	
	/**
	 * Will add the following children to the collection
	 */
	public void addChildren (Object child);

	/**
	 * Will add the following children to the collection
	 */
	public void addChildren (Collection collection);
	
	/**
	 * Will remove the provided children from the child collection
	 * @param child
	 */
	public void removeChildren (Object child);
	
	/**
	 * Will remove all the children contained within this node
	 */
	public void removeAllChildren ();
	
	/**
	 * @return The ID that elements should carry to be included inside this virtual folder
	 */
	public String getGroupID ();
	
	/**
	 * @return true if this node should have a 'Create <type>' menu.
	 */
	public boolean shouldDisplayCreate ();
	
	/** 
	 * @return true if this node should have a 'Add <type>' menu.
	 */
	public boolean shouldDisplayAdd ();
	
	/**
	 * @return the image descriptor for the icon used by the Create or Add menu. 
	 */
	public ImageDescriptor[] getCreateImageDescriptor ();
	
	/** 
	 * @return the text label for the Create or Add menu.
	 */
	public String[] getCreateLabel (); 
	
	/**
	 * @return the type of the object to be created or added using the Create or Add menu.
	 */
	public EClass[] getCreateType ();
}
