/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.services;

import java.io.File;
import java.io.StringWriter;

import org.eclipse.core.resources.IFile;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

/**
 * This interface defines the methods that an alternal sql editor must implement
 */
public interface IAlternateSQLEditor
{
	/**
	 * Gets the editor input to be used when launching the external editor
	 * @param initialString the initial input for the editor
	 * @param title the title for the input.  Maybe used as the title in the editor
	 * @return the external editor input
	 */
	public IAlternateEditorInput getEditorInput(StringWriter stringWriter, String title, ConnectionInfo conn);	
	public IAlternateEditorInput getEditorInput(File sqlFile, ConnectionInfo conn);
	public IAlternateEditorInput getEditorInput(IFile sqlFile, ConnectionInfo conn);
}
