/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.services;

import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public interface IStateProvider
{
	public boolean provides(SQLObject element);

	public State getState(SQLObject element);

	public class State
	{
		private String display;

		private State(String display)
		{
			this.display = display;
		}

		public String getDisplayState()
		{
			return this.display;
		}
		public static final State ALTER = new State(ResourceLoader.getResourceLoader().queryString(
				"DATATOOLS.CORE.UI.STATE.ALTER"));//$NON-NLS-1$
		public static final State CREATE = new State(ResourceLoader.getResourceLoader().queryString(
				"DATATOOLS.CORE.UI.STATE.CREATE"));//$NON-NLS-1$
		public static final State COMMITTED = new State(ResourceLoader.getResourceLoader().queryString(
				"DATATOOLS.CORE.UI.STATE.COMMITTED"));//$NON-NLS-1$
		public static final State COMPARED = new State(ResourceLoader.getResourceLoader().queryString(
				"DATATOOLS.CORE.UI.STATE.COMPARE"));//$NON-NLS-1$
	}
}
