/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.rdb.core.internal.ui.RDBCoreUIPlugin;
import org.eclipse.wst.rdb.core.internal.ui.services.IStateProvider.State;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

public class StateManager
{
	public static final StateManager INSTANCE = new StateManager ();
	
	private final List providerList = new ArrayList ();
	
	private StateManager ()
	{
		IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.core.ui", "stateProvider");//$NON-NLS-1$ //$NON-NLS-2$
		IExtension[] extensions = extensionPoint.getExtensions();
		for(int i=0; i<extensions.length; ++i) 
		{
			IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
			for(int j=0; j<configElements.length; ++j) 
			{
				if(configElements[j].getName().equals("provider"))//$NON-NLS-1$
				{
				    try
                    {
				    	providerList.add(configElements[j].createExecutableExtension("class"));//$NON-NLS-1$
                    }
                    catch (CoreException e)
                    {
					    IStatus status = new Status(IStatus.ERROR, RDBCoreUIPlugin.getDefault().getBundle().getSymbolicName(), IStatus.ERROR,
					            "An error was detected when loading the extension point stateProvider", e); //$NON-NLS-1$
					    RDBCoreUIPlugin.getDefault().getLog().log(status);					
                    }
				}
			}
		}
    }

	public State getState(SQLObject element)
	{
		for (Iterator iterator = providerList.iterator(); iterator.hasNext ();)
		{
			IStateProvider provider = (IStateProvider) iterator.next();
			if (provider.provides(element))
			{
				return provider.getState(element);
			}
		}
		return State.COMMITTED;
	}
}
