/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.tables.helper;

import java.util.Iterator;

import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;



/**
 * @author tomlyn
 *
 */
public class TableHelper 
{
  public static Column findColumn(Table table, String columnName) 
  {
    for (Iterator it = table.getColumns().iterator(); it.hasNext();)
    {
      Column column = (Column) it.next();
            
      if (column.getName().equals(columnName)) 
      {
        return column;
      }
    }

    return null;
  }
}
