/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.core.containment.GroupID;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.icons.ImageDescription;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

public class OpenAction extends AbstractAction {
   
	private static final String TEXT = ServerExtensionsPlugin.getString("UI_MENU_WITH_SQL_EDITOR"); //$NON-NLS-1$  
	
	public void initialize ()
	{
		ImageDescriptor descriptor = ImageDescription.getOpenDescriptor();
    	initializeAction(descriptor, descriptor, TEXT, TEXT);
	}

   /**
    * Launch SQL Editor with DDL of the selected object
    */
   public void run() {
   	try{    		
   	    init();
   	        		    	      	    
   	    Iterator itSelection = selection.iterator(); 
   	    if (itSelection.hasNext()) { 
   	       Object selectedObject = itSelection.next();
   	       if (selectedObject instanceof SQLObject) {
   	          SQLObject sqlObject = (SQLObject)selectedObject;
   	          DatabaseDefinition dbdef = Utility.getDBDef(database);
   	          DDLGenerator ddlGenerator = dbdef.getDDLGenerator();
   	          
   	          SQLObject[] elements = new SQLObject []{sqlObject};
   	          
   	          /* save engineering options of ddlGenerator and set all
   	           * options to true in order to create DDL for all elements
   	           */ 
   	          EngineeringOption[] options = ddlGenerator.getOptions(elements);
   	          ArrayList optionsSettings = new ArrayList(options.length);   	          
   	          for (int i = 0; i < options.length; i++){
   	             EngineeringOption option = (EngineeringOption) options[i];
   	             
   	             if (option != null) {
	   	             optionsSettings.add(i, new Boolean(option.getBoolean()));
	   	             option.setBoolean(true);
   	             }
   	             else {
   	                optionsSettings.add(null);
   	             }   	                
   	          }
   	    		
   	          String[] result = ddlGenerator.createSQLObjects(elements, true, true, new NullProgressMonitor());
   	            	          
   	          // restore engineering options which were set before
   	          for (int i = 0; i < options.length; i++){
   	             EngineeringOption option = (EngineeringOption) options[i];
   	             if (option != null) {
   	                option.setBoolean(((Boolean)optionsSettings.get(i)).booleanValue());
   	             }
   	          }

   	          StringBuffer res = new StringBuffer();
   	          for (int i=0; i<result.length; i++) 
   	          {
   	             res.append(result[i]).append("\n\n");  //$NON-NLS-1$
   	          }
   	          
   	          if (result.length > 0)
   	             launchSQLEditor(res.toString(),sqlObject.getName());
   	       }
   	    }   	    	   	       
        
   	}catch(Exception e) {
   	    ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0, e.getMessage(), e);    		   	    
   	}        
   }   
   
   public void launchSQLEditor(String ddl, String title) {
      
      getEditorLaunch().launchSQLEditor(ddl, 
                                        Utility.getConnectionInfo(database),
                                        title);
   }
   
    public void selectionChanged(SelectionChangedEvent event) {
        
        super.selectionChanged(event);
        
        if (isEnabled() &&
            selection instanceof IStructuredSelection &&
            ((IStructuredSelection)selection).getFirstElement() instanceof EObject ) {
            EObject o = (EObject) ((IStructuredSelection)selection).getFirstElement();
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService(); 
            String groupID = containmentService.getGroupId(o);
            setEnabled( (groupID != null) && (groupID.startsWith(GroupID.CORE_PREFIX)) );
        }
    }
}
