/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.icons.ImageDescription;

/**
 * @author groux
 */
public class SQLTemplateAction extends AbstractAction {

	private static final String TEXT = ServerExtensionsPlugin.getString("UI_MENU_WITH_SQL_EDITOR"); //$NON-NLS-1$  
	
	public void initialize ()
	{
		ImageDescriptor descriptor = ImageDescription.getOpenDescriptor();
    	initializeAction(descriptor, descriptor, TEXT, TEXT);
	}
	
	public void run()
	{
	      try {
	         init();
	         openSQLTemplate();
	      }
	      catch (Exception e) {
	         ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0, e.getMessage(), e);
	      }
		
	}

	
	

}
