/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions.providers;

import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.ICommonMenuConstants;
import org.eclipse.wst.rdb.server.extensions.internal.actions.AbstractAction;
import org.eclipse.wst.rdb.server.extensions.internal.actions.DropAction;

public class DropProvider extends AbstractProvider
{
	private static final DropAction action = new DropAction();
	
	protected String getGroupID ()
	{
		return ICommonMenuConstants.GROUP_EDIT;
	}
	
	public void fillActionBars(IActionBars theActionBars)
	{
		if (getContext().getSelection().isEmpty())
		{
			return;
		}
		getAction().selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.getContext().getSelection()));
		theActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), action);
	}

	protected AbstractAction getAction()
	{
		return action;
	}
}
