/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.editorlaunch;

import org.eclipse.ui.IEditorInput;
import org.eclipse.core.resources.IFile;

/**
 * This interface defines the methods that an external sql editor must implement
 */
public interface IExternalSQLEditor
{
	/**
	 * Gets the editor input to be used when launching the external editor
	 * @param initialString the initial input for the editor
	 * @param title the title for the input.  Maybe used as the title in the editor
	 * @return the external editor input
	 */
	public IEditorInput getEditorInput(String initialString, String title);
	
	/**
	 * Gets the editor input to be used when launching the external editor
	 * @param file the IFile to be used as the resource for this editor input.
	 * Any content this file have will be used as the initial editor content and
	 * the file name will be used as the display name for this input
	 * @return the external editor input
	 */
	public IEditorInput getEditorInput(IFile file);
}