/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.editorlaunch;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorage;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorageEditorInput;

public class LaunchEditor {

   public static int incNumber = 0;
   
   private static final String EXTERNAL_SQL_EDITOR_EXT_POINT = 
	   "org.eclipse.wst.rdb.server.extensions.externalSQLEditor"; //$NON-NLS-1$
   private static final String EXTERNAL_SQL_EDITOR_ID = "id"; //$NON-NLS-1$
   private static final String EXTERNAL_SQL_EDITOR_CLASS = "class"; //$NON-NLS-1$   
    
public void launchSQLEditor(String ddl, ConnectionInfo conInfo, String title) {      
       
	   // If no title passed in, used a default one
       if (title == null | (title.length() == 0))
           title = ServerExtensionsPlugin.getString("DEFAULT_TITLE"); //$NON-NLS-1$
       
       // Make title unique by adding an integer and append the connection name
       title = title + "_" + Integer.toString(++incNumber); //$NON-NLS-1$ /
       
       // Launch the SQl Editor with a DDL statement if no extensions for an
       // external editor exists
       IExtension extension = getExternalSQLEditor();
       if (extension != null)
       {    	   
    	   launchExternalEditor(extension, ddl, title);
       }
       else
       {
    	   // Launch the default SQL Editor
    	   SQLEditorStorage stor = new SQLEditorStorage(title, ddl);
           SQLEditorStorageEditorInput input = new SQLEditorStorageEditorInput(stor);
           input.setConnectionInfo(conInfo);
           try 
           {
        	   ServerExtensionsPlugin.getDefault().getWorkbench()
        	   		.getActiveWorkbenchWindow().getActivePage().openEditor(input,
        	   		"org.eclipse.wst.rdb.server.extensions.editorlaunch.SQLEditorForServerExplorer"); //$NON-NLS-1$
           } catch (Exception ex) {
        	   ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0,
                   ex.getMessage(), ex);        	  
           }
       }
   }

	/**
	 * Launches an external editor specified by extensions
	 * @param extension the extension containing the external editor
	 * @param ddl the initial ddl to display in the editor
	 * @param inputTitle the title for the editor input
	 */
	private void launchExternalEditor(IExtension extension, String ddl, String inputTitle)
	{
		if (extension == null)
		{
			return;
		}
		IConfigurationElement [] configElements = extension.getConfigurationElements();
		for (int i=0;i<configElements.length;i++)
        {
			try
			{
				IConfigurationElement currentConfigElement = configElements[i];
				String editorID = currentConfigElement.getAttribute(EXTERNAL_SQL_EDITOR_ID);
				IExternalSQLEditor extEditor = (IExternalSQLEditor)
					currentConfigElement.createExecutableExtension(EXTERNAL_SQL_EDITOR_CLASS);
				IEditorInput input = extEditor.getEditorInput(ddl, inputTitle);				
				// open external editor
				ServerExtensionsPlugin.getDefault().getWorkbench()
		           .getActiveWorkbenchWindow().getActivePage().openEditor(input, editorID);
			}
			catch (CoreException ex)
			{
				ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0, 
						ex.getMessage(), ex);
			}
        }
		
	}
   
	/**
	 * Gets the external SQL editor extension.  This will return the first one, if more 
	 * then one extensions exists
	 * @return the first extension to the externalSQLEditor extenion-point,
	 * or null if no extension exists.
	 */
	private IExtension getExternalSQLEditor()
	{
		IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = 
			extensionRegistry.getExtensionPoint(EXTERNAL_SQL_EDITOR_EXT_POINT);
		IExtension [] extensions = extensionPoint.getExtensions();
		if (extensions.length > 0)
		{
			return extensions[0];
		}
		return (null);
	}
}