/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.icons;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;

public class ImageDescription
{
	private static final String PATH = "platform:/plugin/org.eclipse.wst.rdb.server.extensions/icons/"; //$NON-NLS-1$
	private static final String DROP = "delete.gif"; //$NON-NLS-1$
	private static final String OPEN = "open.gif"; //$NON-NLS-1$
	
	
	private static ImageDescriptor getDescriptor (String urlPath)
	{
		try
        {
            return ImageDescriptor.createFromURL(new URL(PATH + urlPath));
        }
        catch (MalformedURLException e)
        {
            e.printStackTrace();
            return null;
        }
	}
	
	public static ImageDescriptor getOpenDescriptor ()
	{
	    return getDescriptor (OPEN);
	}
	
	public static ImageDescriptor getDropDescriptor ()
	{
	    return getDescriptor (DROP);
	}
}
