/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial implementation
 ******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.templates;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.osgi.framework.Bundle;

public class TemplateRegistry {

	
	protected static final String PLUGIN_ID = ServerExtensionsPlugin.getUniqueIdentifier();
	protected static final String TEMPLATE_EXTENSION_POINT_ID = PLUGIN_ID + ".sqlTemplates"; //$NON-NLS-1$

	protected static TemplateRegistry instance = null;
	
   private String SEP = System.getProperty("file.separator");//$NON-NLS-1$    

   public static TemplateRegistry getInstance() {
      if (instance == null)
      	instance = new TemplateRegistry();
      return instance;
   }
   
   public SQLTemplate getTemplate(Object obj, String vendorId)
   {
		IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(TEMPLATE_EXTENSION_POINT_ID);
		IConfigurationElement[] e = ep.getConfigurationElements();
		for (int i=0; i<e.length; ++i) {
			String baseDir = e[i].getAttribute("baseDir"); //$NON-NLS-1$
			
			String vendorDir = null;
			IConfigurationElement[] e2 = e[i].getChildren("vendorDirectory"); //$NON-NLS-1$
			for (int j=0; j<e2.length; ++j) {
				if (e2[j].getAttribute("vendorId").equals(vendorId)) { //$NON-NLS-1$
					vendorDir = e2[j].getAttribute("vendorDir"); //$NON-NLS-1$
					break;
				}					
			}
			
			String templateFile = null;
			String title = null;
			e2 = e[i].getChildren("templateFile"); //$NON-NLS-1$
			for (int j=0; j<e2.length; ++j) {
				if (implementsOrExtends(obj,e2[j].getAttribute("objectClass"))) { //$NON-NLS-1$
					templateFile = e2[j].getAttribute("templateFile"); //$NON-NLS-1$
					title = e2[j].getAttribute("title"); //$NON-NLS-1$
					break;
				}
			}
			
			if (vendorDir!=null && templateFile!=null) {
				Bundle otherBundle = Platform.getBundle( e[i].getDeclaringExtension().getNamespace() );
				URL uri = otherBundle.getEntry(baseDir + SEP + vendorDir + SEP + templateFile);
				try {
					File f = new File(Platform.asLocalURL(uri).getPath());
					if (f.exists())
						return new SQLTemplate(obj.getClass().getName(), vendorId, f, title);
				} catch (IOException ex) {
//					ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0,
//		                  "Could not locate template with this URL: " + bundleURL, e);
				}
			}
		}
		return null;
   }
   
   /**
    * Determines if the the class of obj implements or extends the class
    * which name is passed as argument.
    */
   protected boolean implementsOrExtends(Object obj, String className)
   {
		// Extends?
   		for (Class cur = obj.getClass(); cur!=null; cur=cur.getSuperclass())
			if (cur.getName().equals(className))
				return true;

		// Implements?
		Class[] interfaces = obj.getClass().getInterfaces();
		for (int i=0; i<interfaces.length; ++i)
			if (interfaces[i].getName().equals(className))
				return true;
			
   		return false;
	}

}