/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.internal.outputview;

/**
 * This interface defines the methods that an extension must implement to add
 * an XML Data Handler for XML data shown in the Data Output view.  The
 * handler is executed when the user clicks on the ellipsis button for an
 * XML column in the ResultTableViewer.
 */
public interface IOutputViewXMLDataHandler {
	/**
	 * Initialize the handler with the XML data that is to be handled
	 * @param xmlData
	 */
	void init(Object xmlData);
	
	/**
	 * Set the handler with the XML data that is to be handled
	 * @param xmlData
	 */
	void setData(Object xmlData);
	
	/**
	 * Get the XML data from the handler that is to be handled
	 * @return
	 */
    Object getData();
    
    /**
     * Handle the data that is set in the handler. 
     * This method is called when the user clicks on the ellipsis button
     * for an XML data column in the ResultTableViewer.
     */
	void handleData ();
}
