/*******************************************************************************
* Copyright (c) 2000, 2004 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
package org.eclipse.wst.rdb.internal.outputview.actions;

import org.eclipse.jface.action.Action;

import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewActionsTable;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;

/**
 * Removes the selected row from the output table.
 */
public class RemoveOutputTableRow extends Action
{
   /** The table with a row to be removed. */
   protected OutputViewActionsTable outputTable;
   
   /**
    * Constructs an action to remove the selected row of the output table.
    * @param ovTable The table.
    */
   public RemoveOutputTableRow(OutputViewActionsTable ovTable)
   {
      super(OutputViewPlugin.getString("OV_MENU_DELETE"));
      this.outputTable = ovTable;
   }

   /**
    * Runs the action.
    */
   public void run()
   {
      outputTable.removeSelectedItem();
   }
   
   /**
    * Returns true if the selected item is not null and not in progress
    * and if the action is enabled.
    * @return True if the selected item is not null and not in progress
    * and the action is enabled.
    */
   public boolean isEnabled()
   {
      OutputItem item = outputTable.getSelectedItem() ;
      if (item == null)
         return false;
      else if ( item.getStatusCode() == OutputItem.STATUS_IN_PROGRESS)
         return false;
      else
         return super.isEnabled();
   }
}
