/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.connection.resource;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;

public class OfflineHandler extends SAXXMIHandler {

	public OfflineHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
		super(xmiResource, helper, options);
	}

	/**
	 * Restores unicode characters for any &#92;uxxxx encoded character found in
	 * the XML input.
	 * 
	 * @param xml
	 *            XML input with possible &#92;uxxxx encoded characters.
	 * @return The unicode equivalent.
	 */
	public static String decodeValue(String xml) {
		if (xml.indexOf("\\u") == -1) {
			return xml;
		} else {
			int ln = xml.length();
			StringBuffer loadable = new StringBuffer(ln);
			char c, p = 0;
			int v; // The xxxx value.
			int i = 0;
			int unicodeStart = 0;
			while (i < ln) {
				c = xml.charAt(i++);
				if (c == '\\' && p != '\\') {
					c = xml.charAt(i++);
					if (c == 'u') {
						// Read the xxxx
						unicodeStart = i;
						boolean bUnicode = true;
						v = 0;
						for (int u = 0; u < 4 && i < ln; u++) {
							c = xml.charAt(i++);
							switch (c) {
							case '0':
							case '1':
							case '2':
							case '3':
							case '4':
							case '5':
							case '6':
							case '7':
							case '8':
							case '9':
								v = (v << 4) + c - '0';
								break;
							case 'a':
							case 'b':
							case 'c':
							case 'd':
							case 'e':
							case 'f':
								v = (v << 4) + 10 + c - 'a';
								break;
							case 'A':
							case 'B':
							case 'C':
							case 'D':
							case 'E':
							case 'F':
								v = (v << 4) + 10 + c - 'A';
								break;
							default:
								// there are some characters other than hex
								// after unicode, eg: \\uXYZD
								// treat this unicode as it is then, do not
								// convert, mark it
								bUnicode = false;
								// throw new IllegalArgumentException(
								// "Cannot unencode: \\u" + xml.substring(i - u,
								// i));
							}
						} // for
						if (bUnicode) {
							loadable.append((char) v);
						} else { // it's \\u but not in hex format
							loadable.append("\\u");
							for (int u = 0; u < 4 && unicodeStart < ln; u++) {
								c = xml.charAt(unicodeStart++);
								loadable.append(c);
							}
						}
					} else // it's not \\u
					{
						loadable.append(c);
					}
				} else {
					loadable.append(c);
				}
				p = c;
			}
			return loadable.toString();
		}
	}

	/**
	 * Create a feature with the given name for the given object with the given
	 * values.
	 */
	protected void setAttribValue(EObject object, String name, String uval) {
		String value = decodeValue(uval);
		super.setAttribValue(object, name, value);
	}
}
