/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.containment;

import java.util.Collection;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Group;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Role;
import org.eclipse.wst.rdb.internal.models.sql.accesscontrol.User;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;

public class AuthorizationIdContainmentProvider extends AbstractContainmentProvider {

	public Collection getContainedElements(EObject obj) {
	    Collection children = super.getContainedElements(obj);
	    children.addAll(((AuthorizationIdentifier)obj).getReceivedRoleAuthorization());
	    return children;
	}

	public EObject getContainer(EObject obj) {
		return ((AuthorizationIdentifier) obj).getDatabase();
	}

	public EStructuralFeature getContainmentFeature(EObject obj) {
		return SQLSchemaPackage.eINSTANCE.getDatabase_AuthorizationIds();
	}

	public String getGroupId(EObject obj) {
		if (obj instanceof Group) {
			return GroupID.GROUP;
		} 
		
		if (obj instanceof User){
			return GroupID.USER;
		}
		
		if (obj instanceof Role)
		{
			return GroupID.ROLE;
		}
		return null;
	}
}
