/*******************************************************************************
 * Copyright (c) 2001, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.rte;

import java.util.Set;

public class EngineeringOptionID {
	public final static String GENERATE_FULLY_QUALIFIED_NAME   = "GENERATE_FULLY_QUALIFIED_NAME";  //$NON-NLS-1$
	public final static String GENERATE_QUOTED_IDENTIFIER      = "GENERATE_QUOTED_IDENTIFIER"; //$NON-NLS-1$ 
	public final static String GENERATE_DROP_STATEMENTS        = "GENERATE_DROP_STATEMENTS"; //$NON-NLS-1$ 
	public final static String GENERATE_CREATE_STATEMENTS      = "GENERATE_CREATE_STATEMENTS"; //$NON-NLS-1$ 
	public final static String GENERATE_COMMENTS               = "GENERATE_COMMENTS"; //$NON-NLS-1$
    public final static String GENERATE_LABELS                 = "GENERATE_LABELS"; //$NON-NLS-1$
	public final static String GENERATE_IN_TABLESPACE_CLAUSE   = "GENERATE_IN_TABLESPACE_CLAUSE"; //$NON-NLS-1$
	public final static String GENERATE_USE_DOMAIN_IF_EXIST    = "USE_DOMAIN_IF_EXIST"; //$NON-NLS-1$
	public final static String GENERATE_TABLES                 = "GENERATE_TABLES"; //$NON-NLS-1$ 
	public final static String GENERATE_TABLESPACES            = "GENERATE_TABLESPACES"; //$NON-NLS-1$
	public final static String GENERATE_INDICES                = "GENERATE_INDICES"; //$NON-NLS-1$
	public final static String GENERATE_STOREDPROCEDURES       = "GENERATE_STOREDPROCEDURES"; //$NON-NLS-1$
	public final static String GENERATE_FUNCTIONS              = "GENERATE_FUNCTIONS"; //$NON-NLS-1$
	public final static String GENERATE_VIEWS                  = "GENERATE_VIEWS"; //$NON-NLS-1$
	public final static String GENERATE_TRIGGERS               = "GENERATE_TRIGGERS"; //$NON-NLS-1$
	public final static String GENERATE_SEQUENCES              = "GENERATE_SEQUENCES"; //$NON-NLS-1$
	public final static String GENERATE_USER_DEFINED_TYPE      = "GENERATE_USER_DEFINED_TYPE"; //$NON-NLS-1$
	public final static String GENERATE_ENFORCED_CONSTRAINTS   = "GENERATE_ENFORCED_CONSTRAINTS"; //$NON-NLS-1$
	public final static String GENERATE_PK_CONSTRAINTS         = "GENERATE_PK_CONSTRAINTS"; //$NON-NLS-1$
	public final static String GENERATE_FK_CONSTRAINTS         = "GENERATE_FK_CONSTRAINTS"; //$NON-NLS-1$
	public final static String GENERATE_SYNONYM                = "GENERATE_SYNONYM"; //$NON-NLS-1$
	public final static String GENERATE_DATABASE               = "GENERATE_DATABASE"; //$NON-NLS-1$
	public final static String GENERATE_MQT                    = "GENERATE_MQT"; //$NON-NLS-1$
	public final static String GENERATE_ALIAS                  = "GENERATE_ALIAS"; //$NON-NLS-1$
	public final static String GENERATE_CK_CONSTRAINTS         = "GENERATE_CK_CONSTRAINTS"; //$NON-NLS-1$
	public final static String GENERATE_BUFFERPOOL             = "GENERATE_BUFFERPOOL"; //$NON-NLS-1$
	public final static String GENERATE_PARTITIONGROUP         = "GENERATE_PARTITIONGROUP"; //$NON-NLS-1$
    public final static String GENERATE_STORAGEGROUP           = "GENERATE_STORAGEGROUP"; //$NON-NLS-1$
    public final static String GENERATE_SCHEMAS                = "GENERATE_SCHEMA"; //$NON-NLS-1$
    public final static String GENERATE_WRAPPER                = "GENERATE_WRAPPER"; //$NON-NLS-1$    
    public final static String GENERATE_REMOTESERVER           = "GENERATE_REMOTESERVER"; //$NON-NLS-1$
    public final static String GENERATE_USERMAPPING            = "GENERATE_USERMAPPING"; //$NON-NLS-1$
    public final static String GENERATE_NICKNAME               = "GENERATE_NICKNAME"; //$NON-NLS-1$
    public final static String GENERATE_OLAP                   = "GENERATE_OLAP"; //$NON-NLS-1$
	public final static String GENERATE_PRIVILEGE              = "GENERATE_PRIVILEGE"; //$NON-NLS-1$

    //@bd00058820gs
    public static boolean generateDropStatement(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_DROP_STATEMENTS, options);
    }
    
    public static boolean generateCreateStatement(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_CREATE_STATEMENTS, options);
    }

    public static boolean generateCommentStatement(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_COMMENTS, options);
    }

    public static boolean generateLabelStatement(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_LABELS, options);
    }
    
    public static boolean generateDatabase(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_DATABASE, options);
    }
    
    public static boolean generateSchemas(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_SCHEMAS, options);
    }

    public static boolean generateInTablespaceClause(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_IN_TABLESPACE_CLAUSE, options);
    }

    public static boolean useDomain(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_USE_DOMAIN_IF_EXIST, options);
    }
    
    public static boolean generateQuotedIdentifiers(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_QUOTED_IDENTIFIER, options);
    }

    public static boolean generateFullyQualifiedNames(EngineeringOption[] options) {
        return getOptionValueByID(EngineeringOptionID.GENERATE_FULLY_QUALIFIED_NAME, options);
    }

    public static boolean generatePartitionGroup(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_PARTITIONGROUP, options);
    }

    public static boolean generatePrivilege(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_PRIVILEGE, options);
    }

    public static boolean generateStorageGroups(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_STORAGEGROUP, options);
    }
    
    public static boolean generateBufferPool(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_BUFFERPOOL, options);
    }
    
    public static boolean generateAliases(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_ALIAS, options);
    }

    public static boolean generateSynonyms(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_SYNONYM, options);
    }
    
    public static boolean generateTables(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_TABLES, options);
    }
    
    public static boolean generateMQTs(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_MQT, options);
    }

    public static boolean generateTablespaces(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_TABLESPACES, options);
    }
    
    public static boolean generateIndexes(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_INDICES, options);
    }
    
    public static boolean generateStoredProcedures(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_STOREDPROCEDURES, options);
    }

    public static boolean generateViews(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_VIEWS, options);
    }

    public static boolean generateTriggers(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_TRIGGERS, options);
    }

    public static boolean generateSequences(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_SEQUENCES, options);
    }
    
    public static boolean generateFunctions(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_FUNCTIONS, options);
    }
    
    public static boolean generateUserDefinedTypes(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_USER_DEFINED_TYPE, options);
    }

    public static boolean generateCKConstraints(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_CK_CONSTRAINTS, options);
    }
    public static boolean generatePKConstraints(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_PK_CONSTRAINTS, options);
    }
    public static boolean generateFKConstraints(EngineeringOption[] options){
        return getOptionValueByID(EngineeringOptionID.GENERATE_FK_CONSTRAINTS, options);
    }
    
    public static boolean getOptionValue(String optionName, EngineeringOption[] options){
        boolean ret = false;
        for (int i = 0; i < options.length; i++){
            EngineeringOption option = (EngineeringOption) options[i];
            if (option != null && option.getOptionName().equals(optionName)) { //@d00058820gs
                ret = option.getBoolean();
                break;
            }
        }
        return ret;
    }
    
    public static boolean getOptionValueByID(String optionID, EngineeringOption[] options){
        boolean ret = false;
        for (int i = 0; i < options.length; i++){
            EngineeringOption option = (EngineeringOption) options[i];
            if (option !=null && option.getId().equals(optionID)) { //@d00058820gs
                ret = option.getBoolean();
                break;
            }
        }
        return ret;
    }
    
    public static void setOptionValueByID(String optionID, EngineeringOption[] options, boolean value){
        for (int i = 0; i < options.length; i++){
            EngineeringOption option = (EngineeringOption) options[i];
            if (option !=null && option.getId().equals(optionID)) { //@d00058820gs
                option.setBoolean(value);
                break;
            }
        }
    }

    public static final int DATABASE = 1;
    public static final int TABLE = 2;
    public static final int NICKNAME = 4;
    public static final int SERVER = 8;
    public static final int WRAPPER = 16;
    public static final int USER_MAPPING = 32;
    public static final int OLAP_OBJECT = 64;
    public static final int TABLESPACE = 128;
    public static final int INDEX = 256;
    public static final int PROCEDURE = 512;
    public static final int USER_DEFINED_FUNCTION = 1024;
    public static final int VIEW = 2048;
    public static final int TRIGGER = 4096;
    public static final int SEQUENCE = 8192; 
    public static final int USER_DEFINED_TYPE = 16384;
    public static final int UNIQUE_CONSTRAINT = 32768;
    public static final int MATERIALIZED_QUERY_TABLE = 65536;
    public static final int ALIAS = 131072;
    public static final int CHECK_CONSTRAINT = 262144;
    public static final int FOREIGN_KEY = 524288;
    public static final int BUFFER_POOL = 1048576;
    public static final int PARTITION_GROUP = 2097152;
    public static final int SCHEMA = 4194304;
    public static final int DISTINCT_USER_DEFINED_TYPE = 8388608;
    public static final int STRUCTURED_USER_DEFINED_TYPE = 16777216;
    public static final int SYNONYM = 33554432;
    public static final int STORAGE_GROUP = 67108864;
    public static final int PRIVILEGE = 134217728;
    //public static final int COLUMN    
    
    /**
     * @param s
     * @param mask
     */
    public static void populateOptions(Set s, int mask) {
        if ((mask & EngineeringOptionID.DATABASE) == EngineeringOptionID.DATABASE)
            s.add(EngineeringOptionID.GENERATE_DATABASE);
        if ((mask & EngineeringOptionID.TABLE) == EngineeringOptionID.TABLE)
            s.add(EngineeringOptionID.GENERATE_TABLES);
        if ((mask & EngineeringOptionID.NICKNAME) == EngineeringOptionID.NICKNAME)
            s.add(EngineeringOptionID.GENERATE_NICKNAME);
        if ((mask & EngineeringOptionID.SERVER) == EngineeringOptionID.SERVER)
            s.add(EngineeringOptionID.GENERATE_REMOTESERVER);
        if ((mask & EngineeringOptionID.WRAPPER) == EngineeringOptionID.WRAPPER)
            s.add(EngineeringOptionID.GENERATE_WRAPPER);
        if ((mask & EngineeringOptionID.USER_MAPPING) == EngineeringOptionID.USER_MAPPING)
            s.add(EngineeringOptionID.GENERATE_USERMAPPING);
        if ((mask & EngineeringOptionID.OLAP_OBJECT) == EngineeringOptionID.OLAP_OBJECT)
            s.add(EngineeringOptionID.GENERATE_OLAP);
        if ((mask & EngineeringOptionID.TABLESPACE) == EngineeringOptionID.TABLESPACE)
            s.add(EngineeringOptionID.GENERATE_TABLESPACES);
        if ((mask & EngineeringOptionID.INDEX) == EngineeringOptionID.INDEX)
            s.add(EngineeringOptionID.GENERATE_INDICES);
        if ((mask & EngineeringOptionID.PROCEDURE) == EngineeringOptionID.PROCEDURE)
            s.add(EngineeringOptionID.GENERATE_STOREDPROCEDURES);
        if ((mask & EngineeringOptionID.USER_DEFINED_FUNCTION) == EngineeringOptionID.USER_DEFINED_FUNCTION)
            s.add(EngineeringOptionID.GENERATE_FUNCTIONS);
        if ((mask & EngineeringOptionID.VIEW) == EngineeringOptionID.VIEW)
            s.add(EngineeringOptionID.GENERATE_VIEWS);
        if ((mask & EngineeringOptionID.TRIGGER) == EngineeringOptionID.TRIGGER)
            s.add(EngineeringOptionID.GENERATE_TRIGGERS);
        if ((mask & EngineeringOptionID.SEQUENCE) == EngineeringOptionID.SEQUENCE)
            s.add(EngineeringOptionID.GENERATE_SEQUENCES);
        if ((mask & EngineeringOptionID.USER_DEFINED_TYPE) == EngineeringOptionID.USER_DEFINED_TYPE)
            s.add(EngineeringOptionID.GENERATE_USER_DEFINED_TYPE);
        if ((mask & EngineeringOptionID.UNIQUE_CONSTRAINT) == EngineeringOptionID.UNIQUE_CONSTRAINT)
            s.add(EngineeringOptionID.GENERATE_PK_CONSTRAINTS);
        if ((mask & EngineeringOptionID.MATERIALIZED_QUERY_TABLE) == EngineeringOptionID.MATERIALIZED_QUERY_TABLE)
            s.add(EngineeringOptionID.GENERATE_MQT);
        if ((mask & EngineeringOptionID.ALIAS) == EngineeringOptionID.ALIAS)
            s.add(EngineeringOptionID.GENERATE_ALIAS);
        if ((mask & EngineeringOptionID.CHECK_CONSTRAINT) == EngineeringOptionID.CHECK_CONSTRAINT)
            s.add(EngineeringOptionID.GENERATE_CK_CONSTRAINTS);
        if ((mask & EngineeringOptionID.FOREIGN_KEY) == EngineeringOptionID.FOREIGN_KEY)
            s.add(EngineeringOptionID.GENERATE_FK_CONSTRAINTS);
        if ((mask & EngineeringOptionID.BUFFER_POOL) == EngineeringOptionID.BUFFER_POOL)
            s.add(EngineeringOptionID.GENERATE_BUFFERPOOL);
        if ((mask & EngineeringOptionID.SCHEMA) == EngineeringOptionID.SCHEMA)
            s.add(EngineeringOptionID.GENERATE_SCHEMAS);
        if ((mask & EngineeringOptionID.DISTINCT_USER_DEFINED_TYPE) == EngineeringOptionID.DISTINCT_USER_DEFINED_TYPE)
            s.add(EngineeringOptionID.GENERATE_USER_DEFINED_TYPE);
        if ((mask & EngineeringOptionID.STRUCTURED_USER_DEFINED_TYPE) == EngineeringOptionID.STRUCTURED_USER_DEFINED_TYPE)
            s.add(EngineeringOptionID.GENERATE_USER_DEFINED_TYPE);
        if ((mask & EngineeringOptionID.SYNONYM) == EngineeringOptionID.SYNONYM)
            s.add(EngineeringOptionID.GENERATE_SYNONYM);
        if ((mask & EngineeringOptionID.PARTITION_GROUP) == EngineeringOptionID.PARTITION_GROUP)
            s.add(EngineeringOptionID.GENERATE_PARTITIONGROUP);
        if ((mask & EngineeringOptionID.STORAGE_GROUP) == EngineeringOptionID.STORAGE_GROUP)
            s.add(EngineeringOptionID.GENERATE_STORAGEGROUP);
        if ((mask & EngineeringOptionID.PRIVILEGE) == EngineeringOptionID.PRIVILEGE)
            s.add(EngineeringOptionID.GENERATE_PRIVILEGE);
    }    
    //@ed00058820gs
}


