/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.core.rte.jdbc;

import java.sql.Connection;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.impl.ViewTableImpl;


public class JDBCView extends ViewTableImpl implements ICatalogObject {

	public synchronized void refresh() {
		this.columnsLoaded = false;
		
		RefreshManager.getInstance().referesh(this);
	}

	public boolean isSystemObject() {
		return false;
	}

	public Connection getConnection() {
		Database database = this.getCatalogDatabase();
		return ((JDBCDatabase) database).getConnection();
	}
	
	public Database getCatalogDatabase() {
		return this.getSchema().getDatabase();		
	}

	public EList getColumns(){
		if (!this.columnsLoaded) this.loadColumns();
		return this.columns;
	}
	
	public boolean eIsSet(EStructuralFeature eFeature) {
		int id = eDerivedStructuralFeatureID(eFeature);
		if(id == SQLTablesPackage.VIEW_TABLE__COLUMNS) {
			this.getColumns();
		} 
		return super.eIsSet(eFeature);
	}
	
	private synchronized void loadColumns() {
		if(this.columnsLoaded) return;
		
		boolean deliver = this.eDeliver();
		this.eSetDeliver(false);
		try {
			JDBCTable.loadColumns(this.getConnection(), super.getColumns(), this);
		}
		catch(Exception e) {
		}
		this.columnsLoaded = true;
		this.eSetDeliver(deliver);
	}
	
	private boolean columnsLoaded = false;
	
}
