/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.rdb.connection.internal.ui.filter.FilterWizard;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ImagePath;
import org.eclipse.wst.rdb.server.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;


public final class FilterAction extends Action {
	protected IStructuredSelection selection;

	private static final String TEXT = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.ACTIONS.FILTER"); //$NON-NLS-1$
	
	public FilterAction() {
		initialize ();
	}

	protected void initialize ()
	{
		ImageDescriptor descriptor = ImageDescription.getFilterDescriptor();
    	initializeAction(descriptor, descriptor, TEXT, TEXT);
	}

	protected void initializeAction (ImageDescriptor image, ImageDescriptor disabledImage, String text, String toopTip)
    {
		if (image != null)
		{
			this.setImageDescriptor(image);
		}
		if (disabledImage != null)
		{
			this.setDisabledImageDescriptor(disabledImage);
		}
		this.setText(text);
		this.setToolTipText(toopTip);
    }

	public void run() {
		FilterWizard wizard = new FilterWizard(selection);

		wizard.init(PlatformUI.getWorkbench(), null);
		wizard.setNeedsProgressMonitor(false);

		WizardDialog dialog = new WizardDialog(Display.getCurrent()
				.getActiveShell(), wizard);
		dialog.create();
		dialog.getShell().setSize(500, 600);
		dialog.getShell().setText(ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.FILTER")); //$NON-NLS-1$
		dialog.getShell().setImage(ResourceLoader.INSTANCE.queryImageFromRegistry(ImagePath.FILTER_WIZARD_DIALOG));
		dialog.open();	
	}
	
    public void selectionChanged(SelectionChangedEvent event) 
    {
        if (event.getSelection() instanceof IStructuredSelection) 
        {
            this.selection = (IStructuredSelection) event.getSelection();
        }
    }

}
