/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

/**
 * @author ljulien
 */
public class ServerExplorerNav extends CommonNavigator
{
    protected CommonViewer createCommonViewer(Composite aParent)
    {
    	PlatformUI.getWorkbench().getHelpSystem().setHelp(aParent, "org.eclipse.wst.rdb.server.ui.infopop.servexpview");
        return new ServerExplorerViewer(getViewSite().getId(), aParent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
    }

    protected String getFrameToolTipText(Object anElement) {
    	/*
    	 * Ideally, we want to supply the tooltip of the server
    	 * explorer by creating a new label provider in the ServerExplorerViewer
    	 * class. However, since the only input to this method for now is
    	 * a WorkspaceRoot, it would probably be an overkill to do that.
    	 * Therefore, I'm using this as a temporary solution
    	 * until there's a need to create a new label provider.
    	 */
        if (anElement instanceof IWorkspaceRoot)
        {
            return ResourceLoader.INSTANCE.queryString("_UI_TOOLTIP_SERVER_EXPLORER");
        }
        else
        {
            return super.getFrameToolTipText(anElement);
        }
    }
}
