/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

/**
 * @author ljulien
 */
public class ServerExplorerViewer extends CommonViewer
{
    public ServerExplorerViewer(String id, Composite parent)
    {
        this(id, parent, 0);
    }

    public ServerExplorerViewer(String id, Composite parent, int style)
    {
        super(id, parent, style);
    }

    private void traverseChildrenForType (List objectsList, TreeItem [] items, Class type)
    {
        for (int i = 0, n = items.length; i < n; i++)
        {
            TreeItem item = items[i];
            if (item.getData() != null && type.isAssignableFrom(item.getData().getClass()))
            {
                objectsList.add(item.getData());
            }
            traverseChildrenForType (objectsList, item.getItems(), type);
        }
    }
    	
    /**
     * Will allow the Explorer to show elements that are not in the tree yet
     * @param selection
     */
    public void selectInExplorer (ISelection selection)
    {
        this.setSelectionToWidget(selection, true);
        super.updateSelection(selection);
    }
    
    public void updateExplorerSelection(ISelection selection)
    {
        super.updateSelection(selection);
    }
    
    public void clearSelection (ISelection selection)
    {
    	super.setSelectionToWidget(selection, false);
    }
    
    public void showInternal (Object object)
    {
    	TreeItem item = (TreeItem) this.testFindItem(object);
    	if (item != null)
    	{
    		getTree().setTopItem(item);
    	}
    }
    
    /**
     * Will traverse a hierarchy and return the objects in the tree of that type
     * @param info - The connection info
     * @param type - The type to look for
     * @return an array of objects found
     */
    public Object [] getServerExplorerObjectsByType (ConnectionInfo info, Class type)
    {
        Database database = info.getSharedDatabase();
        return getServerExplorerObjectsByType (database, type);
    }

    /**
     * Will traverse a hierarchy and return the objects in the tree of that type
     * @param info - The connection info
     * @param type - The type to look for
     * @return an array of objects found
     */
    public Object [] getServerExplorerObjectsByType (Object parent, Class type)
    {
        List objectsList = new ArrayList ();
        if (parent != null)
        {
            TreeItem [] items =  getServerExplorerChildren (parent);
            traverseChildrenForType (objectsList, items, type);
        }
        return objectsList.toArray(new Object [objectsList.size()]);
    }
    
    /**
     * Internal Call - Will expose the underlying Tree Viewer for easier Navigation
     * @param object
     * @return The Array of children
     */
    public TreeItem[] getServerExplorerChildren(Object object)
    {
        Widget w = findItem(object);
        return w == null ? new TreeItem[0] : (TreeItem [])getChildren(w);
    }

    /**
     * Internal Call - Will expose the underlying Tree Viewer for easier Navigation
     * @param object
     * @return The parent
     */
    public Object getParent(Object object)
    {
        Widget w = findItem(object);
        return w == null || !(w instanceof TreeItem) || (w = getParentItem((TreeItem) w)) == null ? null : w.getData();
    }
}
