/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerConfiguration;
import org.eclipse.wst.rdb.server.internal.ui.explorer.providers.content.impl.ServerExplorerContentProviderNav;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;

public class ExpandAction extends Action
{
	private SelectionChangedEvent event;
	private CommonViewer viewer;
		
	public void initialize ()
	{
		this.viewer = ((ServerExplorerContentProviderNav)IServicesManager.INSTANCE.getServerExplorerContentService()).getViewer();
	}

	private Object getSelection ()
	{
		return ((IStructuredSelection)event.getSelection()).getFirstElement();
	}
	
	private void expand (Object selection)
	{
    	if (this.viewer.getExpandedState(selection))
    	{
    		this.viewer.collapseToLevel(selection, 1);
    	}
    	else 
    	{
    		this.viewer.expandToLevel(selection, 1);
    	}
	}
	
    public void selectionChanged(SelectionChangedEvent event)
    {
    	this.event = event;
    }

    public void run ()
	{
    	Object selection = getSelection();
    	if (selection instanceof IConnectionNode && !((IConnectionNode)selection).isConnected())
    	{
    		IConnectionNode connection = (IConnectionNode) selection;
    		new ServerExplorerConfiguration().restoreConnectionInfo(connection, connection.getConnectionInfo());
    	}
    	else
    	{
    		expand(selection);
    	}
	}
}
