/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.internal.debug.ui.launcher;

import java.net.URI;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.debug.ui.BrowserConfigurationUIListener;
import org.eclipse.vtp.debug.ui.IBrowserConfigurationUI;

public class CommonVoiceXMLBrowserTab
extends AbstractLaunchConfigurationTab {
    protected Image icon = null;
    protected String[] browserIds = null;
    protected IConfigurationElement[] browserElements = null;
    protected Text urlText;
    protected Combo browserCombo;
    protected Composite customPane = null;
    protected Composite mainComposite = null;
    protected ILaunchConfiguration launchConfiguration = null;
    protected IBrowserConfigurationUI currentBrowserUI = null;
    protected int defaultBrowser = -1;

    public void createControl(Composite parent) {
        Composite c;
        this.mainComposite = c = new Composite(parent, 0);
        this.setControl((Control)c);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalIndent = 10;
        c.setLayout((Layout)gl);
        c.setLayoutData((Object)gd);
        Label l = new Label(c, 0);
        l.setText("Browser:");
        l.setLayoutData((Object)new GridData());
        Vector<String> names = new Vector<String>();
        Vector<String> ids = new Vector<String>();
        Vector<IConfigurationElement> browserExtensions = new Vector<IConfigurationElement>();
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.vtp.launching.voiceXMLBrowser");
        if (iep != null) {
            IExtension[] extensions = iep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                if (elements != null) {
                    int j = 0;
                    while (j < elements.length) {
                        String id = elements[j].getAttributeAsIs("id");
                        String name = elements[j].getAttributeAsIs("name");
                        if (new Boolean(elements[j].getAttributeAsIs("default")).equals(Boolean.TRUE)) {
                            this.defaultBrowser = i;
                        }
                        if (id != null && name != null) {
                            ids.add(id);
                            names.add(name);
                            browserExtensions.add(elements[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        String[] browsers = names.toArray(new String[0]);
        this.browserIds = ids.toArray(new String[0]);
        this.browserElements = browserExtensions.toArray(new IConfigurationElement[0]);
        this.browserCombo = new Combo(c, 8);
        this.browserCombo.setItems(browsers);
        this.browserCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonVoiceXMLBrowserTab.this.refreshActiveConfigurationPane();
            }
        });
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.browserCombo.setLayoutData((Object)gd);
        l = new Label(c, 0);
        l.setText("URL:");
        l.setLayoutData((Object)new GridData());
        this.urlText = new Text(c, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonVoiceXMLBrowserTab.this.setDirty(true);
                CommonVoiceXMLBrowserTab.this.updateLaunchConfigurationDialog();
            }
        });
        if (browsers != null && browsers.length > 0) {
            this.browserCombo.select(0);
            this.browserCombo.select(this.defaultBrowser);
            this.refreshActiveConfigurationPane();
        }
    }

    private void refreshActiveConfigurationPane() {
        if (this.customPane != null) {
            this.customPane.dispose();
        }
        this.currentBrowserUI = null;
        int idx = this.browserCombo.getSelectionIndex();
        if (idx == -1 || this.browserIds == null || this.browserIds.length < idx - 1) {
            return;
        }
        try {
            Object o = this.browserElements[idx].createExecutableExtension("configurationUIClass");
            if (o == null || !(o instanceof IBrowserConfigurationUI)) {
                return;
            }
            this.customPane = new Composite(this.mainComposite, 0);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            this.customPane.setLayoutData((Object)gd);
            this.customPane.setLayout((Layout)new GridLayout());
            this.currentBrowserUI = (IBrowserConfigurationUI)o;
            this.currentBrowserUI.drawConfigurationUI(this.customPane, new BrowserConfigurationUIListener(){

                public void contentsChanged() {
                    CommonVoiceXMLBrowserTab.this.setDirty(true);
                    CommonVoiceXMLBrowserTab.this.updateLaunchConfigurationDialog();
                }
            });
            if (this.launchConfiguration != null) {
                this.currentBrowserUI.initializeFrom(this.launchConfiguration);
            }
            this.mainComposite.layout(true, true);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.vtp.launching.voiceXMLBrowser");
        if (iep != null) {
            IExtension[] extensions = iep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                if (elements != null) {
                    int j = 0;
                    while (j < elements.length) {
                        if (new Boolean(elements[j].getAttributeAsIs("default")).equals(Boolean.TRUE)) {
                            this.defaultBrowser = i;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.urlText != null) {
            this.urlText.setText("");
        }
        if (this.browserCombo != null) {
            this.browserCombo.select(0);
            this.browserCombo.select(this.defaultBrowser);
            this.refreshActiveConfigurationPane();
            if (this.currentBrowserUI != null) {
                this.currentBrowserUI.setDefaults(configuration);
            }
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            String url = launchConfig.getAttribute("org.eclipse.vtp.launching.url", "");
            if (url.trim().length() == 0) {
                return false;
            }
            new URI(url.trim());
            String browser = launchConfig.getAttribute("org.eclipse.vtp.launching.browser_id", "");
            if (browser.trim().length() == 0) {
                return false;
            }
            if (this.currentBrowserUI != null) {
                return this.currentBrowserUI.isValid(launchConfig);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.launchConfiguration = configuration;
            if (this.browserCombo != null) {
                this.browserCombo.select(this.defaultBrowser);
            }
            String url = configuration.getAttribute("org.eclipse.vtp.launching.url", "");
            this.urlText.setText(url);
            String browser = configuration.getAttribute("org.eclipse.vtp.launching.browser_id", "");
            if (browser.trim().length() != 0 && this.browserIds != null) {
                int i = 0;
                while (i < this.browserIds.length) {
                    if (this.browserIds[i] != null && this.browserIds[i].equals(browser)) {
                        this.browserCombo.select(i);
                        this.refreshActiveConfigurationPane();
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.vtp.launching.url", this.urlText.getText().trim());
        int idx = this.browserCombo.getSelectionIndex();
        if (idx == -1 || this.browserIds == null || this.browserIds.length < idx - 1) {
            return;
        }
        configuration.setAttribute("org.eclipse.vtp.launching.browser_id", this.browserIds[idx]);
        if (this.currentBrowserUI != null) {
            this.currentBrowserUI.performApply(configuration);
        }
    }

    public String getName() {
        return "Browser";
    }

    public Image getImage() {
        try {
            if (this.icon != null) {
                return this.icon;
            }
            URL imageURL = new URL("platform:/plugin/org.eclipse.vtp.debug.ui/icons/VoiceXMLFile.gif");
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)imageURL);
            this.icon = id.createImage();
            return this.icon;
        }
        catch (Exception exception) {
            return super.getImage();
        }
    }

    public void dispose() {
        if (this.icon != null) {
            try {
                this.icon.dispose();
                this.icon = null;
            }
            catch (Exception exception) {}
        }
        if (this.currentBrowserUI != null) {
            this.currentBrowserUI.dispose();
        }
        super.dispose();
    }
}

