/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.internal.debug.ui.launcher;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vtp.launching.IVoiceXMLBrowser;
import org.eclipse.vtp.launching.VoiceXMLBrowserInput;
import org.eclipse.vtp.launching.VoiceXMLBrowserProcess;
import org.eclipse.vtp.launching.VoiceXMLLogMessage;

public class VoiceXMLBrowserInputView
extends ViewPart {
    protected Composite dtmfComposite = null;
    protected Vector activeBrowsers = new Vector();
    protected VoiceXMLBrowserProcess activeBrowser = null;
    protected Button one;
    protected Button two;
    protected Button three;
    protected Button four;
    protected Button five;
    protected Button six;
    protected Button seven;
    protected Button eight;
    protected Button nine;
    protected Button star;
    protected Button pound;
    protected Button zero;
    protected Action terminateAction = null;
    protected Group logComposite = null;
    protected Table logTable = null;
    protected SimpleDateFormat formatter = null;

    private void fireDTMF(String key) {
        if (this.activeBrowser == null) {
            return;
        }
        VoiceXMLBrowserInput input = new VoiceXMLBrowserInput();
        input.setInputType(1);
        input.setInput((Object)key);
        this.activeBrowser.getVoiceXMLBrowser().sendInput(input);
    }

    private void updateViewMenu() {
        this.terminateAction.setEnabled(this.activeBrowser != null);
        this.getViewSite().getActionBars().updateActionBars();
        IMenuManager imm = this.getViewSite().getActionBars().getMenuManager();
        imm.removeAll();
        if (this.activeBrowsers.size() == 0) {
            Action nothing = new Action("No browsers available."){

                public void run() {
                }
            };
            nothing.setEnabled(true);
            imm.add((IAction)nothing);
        }
        int i = 0;
        while (i < this.activeBrowsers.size()) {
            final VoiceXMLBrowserProcess p = (VoiceXMLBrowserProcess)this.activeBrowsers.get(i);
            Action a = new Action(p.getLabel()){

                public void run() {
                    if (VoiceXMLBrowserInputView.this.activeBrowser == p) {
                        return;
                    }
                    VoiceXMLBrowserInputView.this.activeBrowser = p;
                    VoiceXMLBrowserInputView.this.clearLogTable();
                    VoiceXMLBrowserInputView.this.updateUI();
                }
            };
            a.setChecked(p == this.activeBrowser);
            imm.add((IAction)a);
            ++i;
        }
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void clearLogTable() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (VoiceXMLBrowserInputView.this.logTable != null) {
                    VoiceXMLBrowserInputView.this.logTable.removeAll();
                }
            }
        });
    }

    private void updateUI() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                VoiceXMLBrowserInputView.this.updateViewMenu();
                boolean useDTMF = false;
                if (VoiceXMLBrowserInputView.this.activeBrowser != null && VoiceXMLBrowserInputView.this.activeBrowser.getVoiceXMLBrowser().hasCapability("org.eclipse.vtp.launching.capability_dtmf")) {
                    useDTMF = true;
                }
                VoiceXMLBrowserInputView.this.one.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.two.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.three.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.four.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.five.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.six.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.seven.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.eight.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.nine.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.star.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.zero.setEnabled(useDTMF);
                VoiceXMLBrowserInputView.this.pound.setEnabled(useDTMF);
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        parent.setLayout((Layout)gl);
        this.dtmfComposite = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.dtmfComposite.setLayoutData((Object)gd);
        IToolBarManager itm = this.getViewSite().getActionBars().getToolBarManager();
        this.terminateAction = new Action(){

            public void run() {
                if (VoiceXMLBrowserInputView.this.activeBrowser != null) {
                    VoiceXMLBrowserInputView.this.activeBrowser.getVoiceXMLBrowser().stop();
                    VoiceXMLBrowserInputView.this.activeBrowser = null;
                }
            }
        };
        this.terminateAction.setText("Terminate");
        this.terminateAction.setToolTipText("Terminates the current browser.");
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.debug.ui/icons/full/elcl16/terminate_co.gif"));
            this.terminateAction.setImageDescriptor(id);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        itm.add((IAction)this.terminateAction);
        this.getViewSite().getActionBars().updateActionBars();
        KeyAdapter kl = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                switch (e.character) {
                    case '1': {
                        VoiceXMLBrowserInputView.this.fireDTMF("1");
                        break;
                    }
                    case '2': {
                        VoiceXMLBrowserInputView.this.fireDTMF("2");
                        break;
                    }
                    case '3': {
                        VoiceXMLBrowserInputView.this.fireDTMF("3");
                        break;
                    }
                    case '4': {
                        VoiceXMLBrowserInputView.this.fireDTMF("4");
                        break;
                    }
                    case '5': {
                        VoiceXMLBrowserInputView.this.fireDTMF("5");
                        break;
                    }
                    case '6': {
                        VoiceXMLBrowserInputView.this.fireDTMF("6");
                        break;
                    }
                    case '7': {
                        VoiceXMLBrowserInputView.this.fireDTMF("7");
                        break;
                    }
                    case '8': {
                        VoiceXMLBrowserInputView.this.fireDTMF("8");
                        break;
                    }
                    case '9': {
                        VoiceXMLBrowserInputView.this.fireDTMF("9");
                        break;
                    }
                    case '0': {
                        VoiceXMLBrowserInputView.this.fireDTMF("0");
                        break;
                    }
                    case '*': {
                        VoiceXMLBrowserInputView.this.fireDTMF("*");
                        break;
                    }
                    case '#': {
                        VoiceXMLBrowserInputView.this.fireDTMF("#");
                    }
                }
            }
        };
        this.dtmfComposite.addKeyListener((KeyListener)kl);
        gl = new GridLayout();
        gl.numColumns = 3;
        gl.makeColumnsEqualWidth = true;
        this.dtmfComposite.setLayout((Layout)gl);
        this.one = new Button(this.dtmfComposite, 8);
        this.one.setText("1");
        this.one.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("1");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.one.setLayoutData((Object)gd);
        this.one.addKeyListener((KeyListener)kl);
        this.two = new Button(this.dtmfComposite, 8);
        this.two.setText("2");
        this.two.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("2");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.two.setLayoutData((Object)gd);
        this.two.addKeyListener((KeyListener)kl);
        this.three = new Button(this.dtmfComposite, 8);
        this.three.setText("3");
        this.three.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("3");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.three.setLayoutData((Object)gd);
        this.three.addKeyListener((KeyListener)kl);
        this.four = new Button(this.dtmfComposite, 8);
        this.four.setText("4");
        this.four.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("4");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.four.setLayoutData((Object)gd);
        this.four.addKeyListener((KeyListener)kl);
        this.five = new Button(this.dtmfComposite, 8);
        this.five.setText("5");
        this.five.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("5");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.five.setLayoutData((Object)gd);
        this.five.addKeyListener((KeyListener)kl);
        this.six = new Button(this.dtmfComposite, 8);
        this.six.setText("6");
        this.six.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("6");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.six.setLayoutData((Object)gd);
        this.six.addKeyListener((KeyListener)kl);
        this.seven = new Button(this.dtmfComposite, 8);
        this.seven.setText("7");
        this.seven.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("7");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.seven.setLayoutData((Object)gd);
        this.seven.addKeyListener((KeyListener)kl);
        this.eight = new Button(this.dtmfComposite, 8);
        this.eight.setText("8");
        this.eight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("8");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.eight.setLayoutData((Object)gd);
        this.eight.addKeyListener((KeyListener)kl);
        this.nine = new Button(this.dtmfComposite, 8);
        this.nine.setText("9");
        this.nine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("9");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.nine.setLayoutData((Object)gd);
        this.nine.addKeyListener((KeyListener)kl);
        this.star = new Button(this.dtmfComposite, 8);
        this.star.setText("*");
        this.star.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("*");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.star.setLayoutData((Object)gd);
        this.star.addKeyListener((KeyListener)kl);
        this.zero = new Button(this.dtmfComposite, 8);
        this.zero.setText("0");
        this.zero.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("0");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.zero.setLayoutData((Object)gd);
        this.zero.addKeyListener((KeyListener)kl);
        this.pound = new Button(this.dtmfComposite, 8);
        this.pound.setText("#");
        this.pound.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VoiceXMLBrowserInputView.this.fireDTMF("#");
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.pound.setLayoutData((Object)gd);
        this.pound.addKeyListener((KeyListener)kl);
        this.logComposite = new Group(parent, 0);
        this.logComposite.setText("Log");
        gl = new GridLayout();
        this.logComposite.setLayout((Layout)gl);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.logComposite.setLayoutData((Object)gd);
        this.logTable = new Table((Composite)this.logComposite, 65540);
        this.logTable.setLinesVisible(true);
        this.logTable.setHeaderVisible(true);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.logTable.setLayoutData((Object)gd);
        TableColumn tc1 = new TableColumn(this.logTable, 0);
        tc1.setText("Timestamp");
        tc1.setWidth(100);
        TableColumn tc2 = new TableColumn(this.logTable, 0);
        tc2.setText("Message");
        tc2.setWidth(700);
        try {
            ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            if (launches != null) {
                int i = 0;
                while (i < launches.length) {
                    IProcess[] t = launches[i].getProcesses();
                    if (t != null && t.length > 0 && t[0] instanceof VoiceXMLBrowserProcess) {
                        this.activeBrowsers.add(t[0]);
                        if (this.activeBrowser == null) {
                            this.activeBrowser = (VoiceXMLBrowserProcess)t[0];
                            this.clearLogTable();
                        }
                    }
                    ++i;
                }
            }
            this.updateUI();
            DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    if (events == null) {
                        return;
                    }
                    int i = 0;
                    while (i < events.length) {
                        if (events[i] != null) {
                            if (events[i].getSource() instanceof IVoiceXMLBrowser) {
                                IVoiceXMLBrowser browser = (IVoiceXMLBrowser)events[i].getSource();
                                VoiceXMLBrowserProcess p = browser.getProcess();
                                if (p == null || p != VoiceXMLBrowserInputView.this.activeBrowser) {
                                    return;
                                }
                                if (events[i].getDetail() == 3) {
                                    VoiceXMLLogMessage message = (VoiceXMLLogMessage)events[i].getData();
                                    if (message == null) {
                                        return;
                                    }
                                    String date = "";
                                    if (message.getDate() != null) {
                                        date = VoiceXMLBrowserInputView.this.formatter.format(message.getDate());
                                    }
                                    String fDate = date;
                                    String fMessage = message.getMessage();
                                    Display.getDefault().asyncExec(new Runnable(this, fDate, fMessage){
                                        final /* synthetic */ 19 this$1;
                                        private final /* synthetic */ String val$fDate;
                                        private final /* synthetic */ String val$fMessage;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$fDate = string;
                                            this.val$fMessage = string2;
                                        }

                                        public void run() {
                                            if (19.access$0(this.this$1).logTable != null) {
                                                TableItem ti = new TableItem(19.access$0(this.this$1).logTable, 0);
                                                ti.setText(0, this.val$fDate);
                                                ti.setText(1, this.val$fMessage);
                                                19.access$0(this.this$1).logTable.showItem(ti);
                                            }
                                        }
                                    });
                                }
                            }
                            if (events[i].getKind() == 8 && events[i].getSource() instanceof VoiceXMLBrowserProcess) {
                                VoiceXMLBrowserProcess p = (VoiceXMLBrowserProcess)events[i].getSource();
                                VoiceXMLBrowserInputView.this.activeBrowsers.remove(p);
                                if (VoiceXMLBrowserInputView.this.activeBrowser != null && p.equals(VoiceXMLBrowserInputView.this.activeBrowser)) {
                                    VoiceXMLBrowserInputView.this.activeBrowser = null;
                                }
                                VoiceXMLBrowserInputView.this.updateUI();
                            }
                        }
                        ++i;
                    }
                }

                static /* synthetic */ VoiceXMLBrowserInputView access$0(19 var0) {
                    return var0.VoiceXMLBrowserInputView.this;
                }
            });
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener(new ILaunchListener(){

                public void launchRemoved(ILaunch launch) {
                    IProcess[] t = launch.getProcesses();
                    if (t != null && t.length > 0 && t[0] instanceof VoiceXMLBrowserProcess) {
                        VoiceXMLBrowserInputView.this.activeBrowsers.remove(t[0]);
                        if (VoiceXMLBrowserInputView.this.activeBrowser != null && t[0].equals(VoiceXMLBrowserInputView.this.activeBrowser)) {
                            VoiceXMLBrowserInputView.this.activeBrowser = null;
                            if (VoiceXMLBrowserInputView.this.activeBrowsers.size() > 0) {
                                VoiceXMLBrowserInputView.this.activeBrowser = (VoiceXMLBrowserProcess)VoiceXMLBrowserInputView.this.activeBrowsers.get(0);
                                VoiceXMLBrowserInputView.this.clearLogTable();
                            }
                        }
                    }
                    VoiceXMLBrowserInputView.this.updateUI();
                }

                public void launchAdded(ILaunch launch) {
                    IProcess[] t = launch.getProcesses();
                    if (t != null && t.length > 0 && t[0] instanceof VoiceXMLBrowserProcess) {
                        VoiceXMLBrowserInputView.this.activeBrowsers.add(t[0]);
                        if (VoiceXMLBrowserInputView.this.activeBrowser == null) {
                            VoiceXMLBrowserInputView.this.activeBrowser = (VoiceXMLBrowserProcess)t[0];
                            VoiceXMLBrowserInputView.this.clearLogTable();
                        }
                    }
                    VoiceXMLBrowserInputView.this.updateUI();
                }

                public void launchChanged(ILaunch launch) {
                    IProcess[] t = launch.getProcesses();
                    if (t != null && t.length > 0 && t[0] instanceof VoiceXMLBrowserProcess) {
                        VoiceXMLBrowserInputView.this.activeBrowsers.add(t[0]);
                        if (VoiceXMLBrowserInputView.this.activeBrowser == null) {
                            VoiceXMLBrowserInputView.this.activeBrowser = (VoiceXMLBrowserProcess)t[0];
                            VoiceXMLBrowserInputView.this.clearLogTable();
                        }
                    }
                    VoiceXMLBrowserInputView.this.updateUI();
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setFocus() {
        if (this.dtmfComposite != null) {
            this.dtmfComposite.setFocus();
        }
    }
}

