/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.launching;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.launching.IVoiceXMLBrowser;
import org.eclipse.vtp.launching.VoiceXMLBrowserProcess;

public class VoiceXMLLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    protected String createURLShortname(String url) {
        try {
            URL u = new URL(url);
            return u.getFile();
        }
        catch (Exception exception) {
            return url;
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (mode == null || mode == "debug") {
            return;
        }
        String url = configuration.getAttribute("org.eclipse.vtp.launching.url", "");
        if (url == null || url.trim().length() == 0) {
            return;
        }
        String browserID = configuration.getAttribute("org.eclipse.vtp.launching.browser_id", "");
        if (browserID == null || browserID.trim().length() == 0) {
            return;
        }
        IVoiceXMLBrowser browser = null;
        String browserLabel = this.createURLShortname(url);
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.vtp.launching.voiceXMLBrowser");
        if (iep != null) {
            IExtension[] extensions = iep.getExtensions();
            int i = 0;
            while (browser == null && i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                if (elements != null) {
                    int j = 0;
                    while (browser == null && j < elements.length) {
                        String id = elements[j].getAttributeAsIs("id");
                        if (id != null && id.equals(browserID)) {
                            String launchInputView;
                            Object o = elements[j].createExecutableExtension("class");
                            if (o != null && o instanceof IVoiceXMLBrowser) {
                                browser = (IVoiceXMLBrowser)o;
                            }
                            if ((launchInputView = elements[j].getAttributeAsIs("launchInputView")) != null && launchInputView.trim().toLowerCase().equals("true")) {
                                try {
                                    Display.getDefault().syncExec(new Runnable(){

                                        public void run() {
                                            try {
                                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.vtp.debug.ui.inputView", null, 1);
                                            }
                                            catch (PartInitException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (browser == null) {
            return;
        }
        Map attributes = configuration.getAttributes();
        Iterator I = attributes.keySet().iterator();
        while (I.hasNext()) {
            Object o = I.next();
            if (!(o instanceof String)) continue;
            String key = (String)o;
            browser.setProperty(key, attributes.get(key));
        }
        VoiceXMLBrowserProcess proc = new VoiceXMLBrowserProcess(launch, browser);
        proc.setLabel(browserLabel);
        launch.addProcess((IProcess)proc);
        browser.setProcess(proc);
        DebugEvent[] eventSet = new DebugEvent[]{new DebugEvent((Object)proc, 4), new DebugEvent((Object)launch, 16)};
        DebugPlugin.getDefault().fireDebugEventSet(eventSet);
        browser.start();
    }
}

