/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.srgxml.ui.internal.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.vtp.catalog.registry.CatalogDefaultResolver;
import org.eclipse.vtp.catalog.registry.CatalogEntry;
import org.eclipse.vtp.editor.srgxml.ui.internal.wizards.NewSRGXMLFileContentGenerator;
import org.eclipse.vtp.editor.wizards.NewXMLGenerator;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.ui.internal.wizards.XMLSchemaValidationChecker;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;

public class NewSRGXMLGenerator
extends NewXMLGenerator {
    protected String grammarURI;
    protected CMDocument cmDocument;
    protected int buildPolicy;
    protected String rootElementName;
    protected ICatalogEntry xmlCatalogEntry;
    protected String publicId;
    protected String systemId;
    protected String defaultSystemId;
    public List namespaceInfoList;

    public NewSRGXMLGenerator() {
    }

    public NewSRGXMLGenerator(String grammarURI, CMDocument cmDocument) {
        this.grammarURI = grammarURI;
        this.cmDocument = cmDocument;
    }

    public static CMDocument createCMDocument(String uri, String[] errorInfo) {
        String title = null;
        String message = null;
        Vector errorList = new Vector();
        CMDocument cmDocument = null;
        if (URIHelper.isReadableURI((String)uri, (boolean)true)) {
            uri = URIHelper.normalize((String)uri, null, null);
            cmDocument = ContentModelManager.getInstance().createCMDocument(uri, null);
            if (uri.endsWith(".dtd")) {
                if (errorList.size() > 0) {
                    title = XMLWizardsMessages._UI_INVALID_GRAMMAR_ERROR;
                    message = XMLWizardsMessages._UI_LABEL_ERROR_DTD_INVALID_INFO;
                }
            } else {
                int globalElementCount;
                XMLSchemaValidationChecker validator = new XMLSchemaValidationChecker();
                if (!validator.isValid(uri)) {
                    title = XMLWizardsMessages._UI_INVALID_GRAMMAR_ERROR;
                    message = XMLWizardsMessages._UI_LABEL_ERROR_SCHEMA_INVALID_INFO;
                } else if (cmDocument != null && (globalElementCount = cmDocument.getElements().getLength()) == 0) {
                    title = XMLWizardsMessages._UI_WARNING_TITLE_NO_ROOT_ELEMENTS;
                    message = XMLWizardsMessages._UI_WARNING_MSG_NO_ROOT_ELEMENTS;
                }
            }
        } else {
            title = XMLWizardsMessages._UI_WARNING_TITLE_NO_ROOT_ELEMENTS;
            message = String.valueOf(XMLWizardsMessages._UI_WARNING_URI_NOT_FOUND_COLON) + " " + uri;
        }
        errorInfo[0] = title;
        errorInfo[1] = message;
        return cmDocument;
    }

    public void createDefaultXMLDocument(IFile newFile, String xmlFileName, String rootElementName, String contentType) throws Exception {
        CatalogEntry dtd = CatalogDefaultResolver.getDefaultEntryForContentType((String)contentType);
        this.publicId = dtd.getKey();
        this.systemId = dtd.getWebURL() != null ? dtd.getWebURL() : dtd.getURI();
        String charset = this.getUserPreferredCharset();
        if (charset == null) {
            charset = "UTF-8";
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String charSet = this.getUserPreferredCharset();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, charSet));
        NewSRGXMLFileContentGenerator generator = new NewSRGXMLFileContentGenerator(dtd);
        writer.println(generator.getNewFileContent(false, rootElementName, contentType));
        writer.flush();
        outputStream.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        newFile.setContents((InputStream)inputStream, true, true, null);
        inputStream.close();
    }
}

